/*
 * Decompiled with CFR 0.152.
 */
package de.jgsoftwares.dnsserver.config;

import com.zaxxer.hikari.HikariConfig;
import java.sql.SQLException;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.h2.tools.Server;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"de.jgsoftwares.dnsserver.dao"}, entityManagerFactoryRef="entityManagerFactory", transactionManagerRef="transactionManager")
public class DemoDBConfig
extends HikariConfig {
    @Autowired
    @Qualifier(value="defaultJdbcTemplate")
    JdbcTemplate jtm;

    public DemoDBConfig() {
        DemoDBConfig.startH2Server();
    }

    private static void startH2Server() {
        try {
            Server h2Server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9092", "-tcpAllowOthers"}).start();
            if (h2Server.isRunning(true)) {
                System.out.print("H2 server was started and is running.\n");
            } else {
                h2Server = Server.createTcpServer((String[])new String[0]).start();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to start H2 server: " + String.valueOf(e) + "\n");
        }
    }

    @Primary
    @Bean(name={"dataSource"})
    @Qualifier(value="demodb")
    @ConfigurationProperties(prefix="spring.demodb.datasource")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder builder, @Qualifier(value="demodb") DataSource dataSource) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        return builder.dataSource(dataSource).properties(properties).packages(new String[]{"de.jgsoftwares.dnsserver.model"}).persistenceUnit("DemoDb").build();
    }

    @Primary
    @Bean(name={"transactionManager"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManagerFactory") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

    @Primary
    @Bean(name={"defaultJdbcTemplate"})
    public JdbcTemplate jdbcTemplate(@Qualifier(value="dataSource") DataSource demodb) {
        this.jtm = new JdbcTemplate();
        this.jtm.setDataSource(demodb);
        return this.jtm;
    }
}

