/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer.rmi;

import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import jrdesktop.server.rmi.ServerInterface;
import jrdesktop.utilities.InetAdrUtility;
import jrdesktop.utilities.ZipUtility;
import jrdesktop.viewer.Config;
import jrdesktop.viewer.Recorder;

public class Viewer
extends Thread {
    private int index = -1;
    private Recorder recorder;
    private Registry registry;
    private ServerInterface rmiServer;
    private String server = "127.0.0.1";
    private int port = 6666;
    private boolean connected = false;
    private ArrayList<Object> Objects;

    public Viewer() {
        Config.loadConfiguration();
        this.server = Config.server_address;
        this.port = Config.server_port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void Start() {
        this.connect();
        if (this.connected) {
            this.recorder = new Recorder(this);
            this.recorder.viewerGUI.Start();
        } else {
            this.Stop();
        }
    }

    public void Stop() {
        if (this.recorder != null) {
            this.recorder.Stop();
            this.recorder.interrupt();
        }
        this.disconnect();
        this.interrupt();
    }

    public int connect() {
        this.connected = false;
        try {
            this.registry = LocateRegistry.getRegistry(this.server, this.port);
            this.rmiServer = (ServerInterface)this.registry.lookup("ServerImpl");
            this.index = this.rmiServer.startViewer(InetAdrUtility.getLocalAdr());
            this.displayStatus();
            this.Objects = new ArrayList();
            this.connected = true;
            return this.index;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error !!", 0);
            return -1;
        }
    }

    public void disconnect() {
        this.connected = false;
        try {
            if (this.rmiServer != null) {
                this.rmiServer.stopViewer(this.index);
                UnicastRemoteObject.unexportObject(this.rmiServer, true);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        this.rmiServer = null;
        this.registry = null;
    }

    public void updateData(Object object) {
        try {
            byte[] data = ZipUtility.objecttoByteArray(object);
            this.updateData(data);
        }
        catch (IOException e) {
            e.getStackTrace();
        }
    }

    public void updateData(byte[] data) {
        try {
            this.rmiServer.updateData(data, this.index);
        }
        catch (Exception re) {
            re.getStackTrace();
        }
    }

    public void AddObject(Object object) {
        this.Objects.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData() {
        ArrayList<Object> SendObjects;
        ArrayList<Object> arrayList = this.Objects;
        synchronized (arrayList) {
            SendObjects = this.Objects;
            this.Objects = new ArrayList();
        }
        this.updateData(SendObjects);
    }

    public void recieveData() {
        Object object = null;
        try {
            byte[] data = this.rmiServer.updateData(this.index);
            object = ZipUtility.byteArraytoObject(data);
            this.recorder.updateData((ArrayList)object);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public void displayStatus() {
        System.out.println("Viewer connected to " + this.rmiServer);
    }
}

