/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util.resources;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.application.DevMode;
import org.minimalj.model.Code;
import org.minimalj.model.View;
import org.minimalj.model.ViewUtil;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.LocaleContext;
import org.minimalj.util.resources.MultiResourceBundle;

public class Resources {
    private static final Logger logger = Logger.getLogger(Resources.class.getName());
    private static Set<String> resourceBundleNames = new HashSet<String>();
    public static final boolean OPTIONAL = false;
    public static final String APPLICATION_NAME = "Application.name";
    public static final String APPLICATION_ICON = "Application.icon";
    private static final Map<Locale, Resources> resourcesByLocale = new HashMap<Locale, Resources>();
    private ResourceBundle resourceBundle;
    private static final Set<String> missing = new TreeSet<String>();
    private static Map<String, String> mimeTypeByPostfix = new HashMap<String, String>();

    private Resources(Locale locale) {
        this.resourceBundle = ResourceBundle.getBundle(Resources.class.getPackage().getName() + ".MinimalJ", locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        for (String resourceBundleName : resourceBundleNames) {
            this.resourceBundle = new MultiResourceBundle(this.resourceBundle, ResourceBundle.getBundle(resourceBundleName, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES)));
        }
    }

    public static ResourceBundle getResourceBundle() {
        Locale locale = LocaleContext.getCurrent();
        if (!resourcesByLocale.containsKey(locale)) {
            resourcesByLocale.put(locale, new Resources(locale));
        }
        return Resources.resourcesByLocale.get((Object)locale).resourceBundle;
    }

    public static void addResourceBundleName(String resourceBundleName) {
        resourceBundleNames.add(resourceBundleName);
        resourcesByLocale.clear();
    }

    public static boolean isAvailable(String resourceName) {
        return Resources.getResourceBundle().containsKey(resourceName);
    }

    public static Integer getInteger(String resourceName, boolean reportIfMissing) {
        if (Resources.isAvailable(resourceName)) {
            String integerString = Resources.getString(resourceName);
            try {
                return Integer.parseInt(integerString);
            }
            catch (NumberFormatException nfe) {
                logger.warning("Number format wrong for resource " + resourceName + "('" + integerString + "')");
                return null;
            }
        }
        Resources.reportMissing(resourceName, reportIfMissing);
        return null;
    }

    public static String getString(String resourceName) {
        return Resources.getString(resourceName, true);
    }

    public static String getString(String resourceName, boolean reportIfMissing) {
        if (Resources.isAvailable(resourceName)) {
            return Resources.getResourceBundle().getString(resourceName);
        }
        Resources.reportMissing(resourceName, reportIfMissing);
        return "'" + resourceName + "'";
    }

    public static void reportMissing(String resourceName, boolean reportIfMissing) {
        if (reportIfMissing && DevMode.isActive()) {
            missing.add(resourceName);
        }
    }

    public static void printMissing() {
        missing.stream().forEach(s -> System.out.println(s + " = "));
    }

    public static String getString(Class<?> clazz) {
        String result = Resources.getStringOrNull(clazz);
        if (result != null) {
            return result;
        }
        return Resources.getString(clazz.getSimpleName());
    }

    public static String getStringOrNull(Class<?> clazz) {
        Class<?> viewedClass;
        String byViewedClass;
        if (Resources.isAvailable(clazz.getName())) {
            return Resources.getString(clazz.getName());
        }
        if (Resources.isAvailable(clazz.getSimpleName())) {
            return Resources.getString(clazz.getSimpleName());
        }
        if (View.class.isAssignableFrom(clazz) && !Code.class.isAssignableFrom(clazz) && (byViewedClass = Resources.getStringOrNull(viewedClass = ViewUtil.getViewedClass(clazz))) != null) {
            return byViewedClass;
        }
        return null;
    }

    public static String getPropertyName(PropertyInterface property) {
        return Resources.getPropertyName(Resources.getResourceBundle(), property);
    }

    public static String getPropertyName(PropertyInterface property, String postfix) {
        String result = Resources.getPropertyName(Resources.getResourceBundle(), property, postfix);
        if (result == null) {
            result = Resources.getPropertyName(Resources.getResourceBundle(), property);
        }
        return result;
    }

    private static String getPropertyName(ResourceBundle resourceBundle, PropertyInterface property) {
        return Resources.getPropertyName(resourceBundle, property, null);
    }

    private static String getPropertyName(ResourceBundle resourceBundle, PropertyInterface property, String postfix) {
        String fieldName = property.getName();
        if (postfix != null) {
            fieldName = fieldName + postfix;
        }
        Class<?> declaringClass = property.getDeclaringClass();
        Class<?> fieldClass = property.getClazz();
        return Resources.getPropertyName(resourceBundle, fieldName, declaringClass, fieldClass, postfix != null);
    }

    private static String getPropertyName(ResourceBundle resourceBundle, String fieldName, Class<?> declaringClass, Class<?> fieldClass, boolean optional) {
        String completeQualifiedKey = declaringClass.getName() + "." + fieldName;
        if (resourceBundle.containsKey(completeQualifiedKey)) {
            return resourceBundle.getString(completeQualifiedKey);
        }
        String qualifiedKey = declaringClass.getSimpleName() + "." + fieldName;
        if (resourceBundle.containsKey(qualifiedKey)) {
            return resourceBundle.getString(qualifiedKey);
        }
        if (View.class.isAssignableFrom(declaringClass) && !Code.class.isAssignableFrom(declaringClass)) {
            Class<?> viewedClass = ViewUtil.getViewedClass(declaringClass);
            return Resources.getPropertyName(resourceBundle, fieldName, viewedClass, fieldClass, optional);
        }
        String byFieldClass = Resources.getStringOrNull(fieldClass);
        if (byFieldClass != null) {
            return byFieldClass;
        }
        if (resourceBundle.containsKey(fieldName)) {
            return resourceBundle.getString(fieldName);
        }
        if (!optional) {
            Resources.reportMissing(qualifiedKey, true);
            return "'" + qualifiedKey + "'";
        }
        return null;
    }

    public static String getResourceName(Class<?> clazz) {
        if (clazz.isAnonymousClass()) {
            clazz = clazz.getSuperclass();
        }
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            if (Resources.isAvailable(c.getName())) {
                return c.getName();
            }
            if (!Resources.isAvailable(c.getSimpleName())) continue;
            return c.getSimpleName();
        }
        return clazz.getSimpleName();
    }

    public static void addMimeType(String postfix, String contentType) {
        mimeTypeByPostfix.put(postfix, contentType);
    }

    public static String getMimeType(String postfix) {
        return mimeTypeByPostfix.get(postfix);
    }

    static {
        mimeTypeByPostfix.put("html", "text/html");
        mimeTypeByPostfix.put("css", "text/css");
        mimeTypeByPostfix.put("js", "application/javascript");
        mimeTypeByPostfix.put("jpg", "image/jpg");
        mimeTypeByPostfix.put("png", "image/png");
    }

    private static class NoFallbackUTF8Control
    extends ResourceBundle.Control {
        private NoFallbackUTF8Control() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            Objects.requireNonNull(baseName);
            return ResourceBundle.Control.FORMAT_PROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            Objects.requireNonNull(baseName);
            Objects.requireNonNull(locale);
            return null;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            URL resourceURL = loader.getResource(resourceName);
            if (resourceURL != null) {
                try {
                    return new PropertyResourceBundle(new InputStreamReader(resourceURL.openStream(), Charset.forName("UTF-8")));
                }
                catch (Exception z) {
                    logger.log(Level.FINE, "exception thrown during bundle initialization", z);
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    }
}

