/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.application.Configuration;

public class ReservedSqlWords {
    private static final Logger logger = Logger.getLogger(ReservedSqlWords.class.getName());
    public static final Collection<String> reservedSqlWords = Collections.unmodifiableCollection(ReservedSqlWords.loadReservedSqlWords());

    private static Collection<String> loadReservedSqlWords() {
        HashSet<String> reservedSqlWords = new HashSet<String>();
        String fileName = Configuration.get("MjReservedSqlWordsFile", "reservedSqlWords.txt");
        try (InputStreamReader isr = new InputStreamReader(ReservedSqlWords.class.getResourceAsStream(fileName));
             BufferedReader r = new BufferedReader(isr);){
            while (r.ready()) {
                String[] words;
                String line = r.readLine();
                if (line.startsWith("#")) continue;
                for (String word : words = line.split(" ")) {
                    reservedSqlWords.add(word);
                }
            }
        }
        catch (NullPointerException e) {
            logger.severe("reservedSqlWords.txt not found. Maybe something is wrong with the classpath");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "reservedSqlWords.txt could not be read", e);
        }
        return reservedSqlWords;
    }
}

