/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.minimalj.util.LoggingRuntimeException;

public class IdUtils {
    private static final Logger logger = Logger.getLogger(IdUtils.class.getName());
    private static final Map<Class<?>, Field> idFieldOfClass = new HashMap(200);

    private static Field getIdField(Class<?> clazz) {
        if (idFieldOfClass.containsKey(clazz)) {
            return idFieldOfClass.get(clazz);
        }
        try {
            Field idField = clazz.getField("id");
            idFieldOfClass.put(clazz, idField);
            return idField;
        }
        catch (NoSuchFieldException e) {
            idFieldOfClass.put(clazz, null);
            return null;
        }
        catch (SecurityException e) {
            throw new LoggingRuntimeException(e, logger, "getting Id failed");
        }
    }

    public static boolean hasId(Class<?> clazz) {
        return IdUtils.getIdField(clazz) != null;
    }

    public static Object getId(Object object) {
        Objects.nonNull(object);
        try {
            Field idField = IdUtils.getIdField(object.getClass());
            if (idField == null) {
                throw new IllegalArgumentException(object.getClass().getName() + " has no id field to get");
            }
            Object id = idField.get(object);
            return id;
        }
        catch (IllegalAccessException | SecurityException e) {
            throw new LoggingRuntimeException(e, logger, "getting Id failed");
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a != null && IdUtils.hasId(a.getClass())) {
            a = IdUtils.getId(a);
        }
        if (b != null && IdUtils.hasId(b.getClass())) {
            b = IdUtils.getId(b);
        }
        return Objects.equals(a, b);
    }

    public static void setId(Object object, Object id) {
        try {
            Field idField = IdUtils.getIdField(object.getClass());
            if (idField != null) {
                idField.set(object, id);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new LoggingRuntimeException(e, logger, "setting Id failed");
        }
    }

    public static void setVersion(Object object, int version) {
        try {
            Field versionField = object.getClass().getField("version");
            if (versionField.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("Cannot set version on field with " + versionField.getType());
            }
            versionField.set(object, version);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getVersion(Object object) {
        try {
            Field versionField = object.getClass().getField("version");
            if (versionField.getType() == Integer.TYPE) {
                return (Integer)versionField.get(object);
            }
            throw new IllegalArgumentException("Cannot set version on field with " + versionField.getType());
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setHistorized(Object object, int historized) {
        try {
            Field historizedField = object.getClass().getField("historized");
            historizedField.set(object, historized > 0);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getIdString(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return String.valueOf(IdUtils.getId(object));
    }

    public static String getCompactIdString(Object object) {
        return IdUtils.getIdString(object).replace("-", "");
    }

    public static Object createId() {
        return UUID.randomUUID().toString();
    }
}

