/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.util.StringUtils;

public class ExceptionUtils {
    public static void logReducedStackTrace(Logger logger, Exception exception) {
        Exception here = new Exception();
        String[] hereStrings = ExceptionUtils.getStackFrames(here);
        String[] throwableStrings = ExceptionUtils.getStackFrames(exception);
        int linesToSkip = 1;
        while (throwableStrings.length - linesToSkip > 0 && hereStrings.length - linesToSkip > 0 && StringUtils.equals(hereStrings[hereStrings.length - linesToSkip], throwableStrings[throwableStrings.length - linesToSkip])) {
            ++linesToSkip;
        }
        for (int i = 0; i <= throwableStrings.length - linesToSkip; ++i) {
            logger.log(Level.SEVERE, throwableStrings[i]);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    private static String[] getStackFrames(String stackTrace) {
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }
}

