/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.util.FieldUtils;

public class EntityWriter {
    private final DataOutputStream dos;

    public EntityWriter(OutputStream outputStream) {
        this.dos = new DataOutputStream(outputStream);
    }

    private void writeObject(Object object) throws IOException {
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getDeclaredFields();
        Arrays.sort(fields, new FlatProperties.FieldComparator());
        for (Field field : fields) {
            if (FieldUtils.isTransient(field) || FieldUtils.isStatic(field)) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            Class<Object> fieldClass = field.getType();
            if (fieldClass == Object.class && "id".equals(field.getName())) {
                fieldClass = String.class;
            }
            if (this.writePrimitiv(value, fieldClass)) continue;
            this.writeIfNotNull(value);
        }
    }

    private void writeIfNotNull(Object value) throws IOException {
        if (value != null) {
            this.dos.write(1);
            this.writeObject(value);
        } else {
            this.dos.write(0);
        }
    }

    private boolean writePrimitiv(Object value, Class<?> fieldClazz) throws IOException {
        if (value == null) {
            this.dos.write(0);
            return true;
        }
        if (fieldClazz == String.class) {
            this.writeString((String)value);
        } else if (fieldClazz == Byte.TYPE) {
            this.dos.write(((Byte)value).byteValue());
        } else if (fieldClazz == Short.TYPE) {
            this.dos.writeShort(((Short)value).shortValue());
        } else if (fieldClazz == Integer.TYPE) {
            this.dos.writeInt((Integer)value);
        } else if (fieldClazz == Long.TYPE) {
            this.dos.writeLong((Long)value);
        } else if (fieldClazz == Boolean.TYPE) {
            this.dos.write((Boolean)value != false ? 1 : 0);
        } else if (fieldClazz == Byte.class) {
            this.dos.write(1);
            this.dos.write(((Byte)value).byteValue());
        } else if (fieldClazz == Short.class) {
            this.dos.write(1);
            this.dos.writeShort(((Short)value).shortValue());
        } else if (fieldClazz == Integer.class) {
            this.dos.write(1);
            this.dos.writeInt((Integer)value);
        } else if (fieldClazz == Long.class) {
            this.dos.write(1);
            this.dos.writeLong((Long)value);
        } else if (fieldClazz == Boolean.class) {
            this.dos.write(1);
            this.dos.write((Boolean)value != false ? 1 : 0);
        } else if (fieldClazz == List.class) {
            List list = (List)value;
            this.dos.writeInt(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.writeIfNotNull(list.get(i));
            }
        } else if (fieldClazz.isArray()) {
            int arrayLength = Array.getLength(value);
            this.dos.writeInt(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.writeIfNotNull(Array.get(value, i));
            }
        } else if (value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                this.dos.writeInt(0);
            } else {
                Class<?> enumClass = set.iterator().next().getClass();
                int asInt = EnumUtils.getInt(set, enumClass);
                this.dos.writeInt(asInt);
            }
        } else if (value instanceof LocalDate) {
            this.dos.write(1);
            this.write((LocalDate)value);
        } else if (value instanceof LocalTime) {
            this.dos.write(1);
            this.write((LocalTime)value);
        } else if (value instanceof LocalDateTime) {
            this.dos.write(1);
            this.write((LocalDateTime)value);
        } else if (Enum.class.isAssignableFrom(fieldClazz)) {
            this.dos.writeByte(((Enum)value).ordinal() + 1);
        } else {
            return false;
        }
        return true;
    }

    private void write(LocalDate value) throws IOException {
        this.dos.writeInt(value.getYear());
        this.dos.writeByte(value.getMonthValue());
        this.dos.writeByte(value.getDayOfMonth());
    }

    private void write(LocalTime value) throws IOException {
        int nano = value.getNano();
        int second = value.getSecond();
        int minute = value.getMinute();
        int hour = value.getHour();
        if (nano == 0) {
            if (second == 0) {
                if (minute == 0) {
                    this.dos.writeByte(~hour);
                } else {
                    this.dos.writeByte(hour);
                    this.dos.writeByte(~minute);
                }
            } else {
                this.dos.writeByte(hour);
                this.dos.writeByte(minute);
                this.dos.writeByte(~second);
            }
        } else {
            this.dos.writeByte(hour);
            this.dos.writeByte(minute);
            this.dos.writeByte(second);
            this.dos.writeInt(nano);
        }
    }

    private void write(LocalDateTime value) throws IOException {
        this.write(value.toLocalDate());
        this.write(value.toLocalTime());
    }

    private void writeString(String value) throws IOException {
        int chunkSize = 20000;
        int chunks = (value.length() - 1) / chunkSize + 1;
        this.dos.write(chunks);
        for (int i = 0; i < chunks; ++i) {
            this.dos.writeUTF(value.substring(chunkSize * i, Math.min(chunkSize * (i + 1), value.length())));
        }
    }

    public void write(Object object) throws IOException {
        if (object != null) {
            this.writeString(object.getClass().getName());
            this.writeIfNotNull(object);
        } else {
            this.dos.write(0);
        }
    }
}

