/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.LoggingRuntimeException;

public class EntityReader {
    private static final Logger logger = Logger.getLogger(EntityReader.class.getName());
    private final DataInputStream dis;

    public EntityReader(InputStream inputStream) {
        this.dis = new DataInputStream(inputStream);
    }

    private Object read(Class<?> fieldClazz) throws IOException {
        if (fieldClazz == Byte.TYPE) {
            return new Byte(this.dis.readByte());
        }
        if (fieldClazz == Short.TYPE) {
            return new Short(this.dis.readShort());
        }
        if (fieldClazz == Integer.TYPE) {
            return new Integer(this.dis.readInt());
        }
        if (fieldClazz == Long.TYPE) {
            return new Long(this.dis.readLong());
        }
        if (fieldClazz == Boolean.TYPE) {
            return this.dis.read() != 0;
        }
        if (Enum.class.isAssignableFrom(fieldClazz)) {
            byte b = this.dis.readByte();
            if (b == 0) {
                return null;
            }
            return EnumUtils.valueList(fieldClazz).get(b - 1);
        }
        int b = this.dis.read();
        if (b == 0) {
            return null;
        }
        if (fieldClazz == String.class) {
            return this.readString(b);
        }
        if (fieldClazz == Byte.class) {
            return (byte)this.dis.read();
        }
        if (fieldClazz == Short.class) {
            return this.dis.readShort();
        }
        if (fieldClazz == Integer.class) {
            return this.dis.readInt();
        }
        if (fieldClazz == Long.class) {
            return this.dis.readLong();
        }
        if (fieldClazz == Boolean.class) {
            return this.dis.read() != 0;
        }
        if (LocalDate.class.isAssignableFrom(fieldClazz)) {
            return EntityReader.readLocalDate(this.dis);
        }
        if (LocalTime.class.isAssignableFrom(fieldClazz)) {
            return EntityReader.readLocalTime(this.dis);
        }
        if (LocalDateTime.class.isAssignableFrom(fieldClazz)) {
            return EntityReader.readLocalDateTime(this.dis);
        }
        if (fieldClazz.isArray()) {
            int length = this.dis.readInt();
            Object objects = Array.newInstance(fieldClazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(objects, i, this.read(fieldClazz));
            }
            return objects;
        }
        return this.readObject(fieldClazz);
    }

    private static LocalDate readLocalDate(DataInputStream dis) throws IOException {
        int year = dis.readInt();
        byte month = dis.readByte();
        byte dayOfMonth = dis.readByte();
        return LocalDate.of(year, month, (int)dayOfMonth);
    }

    private static LocalTime readLocalTime(DataInputStream in) throws IOException {
        int hour = in.readByte();
        int minute = 0;
        int second = 0;
        int nano = 0;
        if (hour < 0) {
            hour ^= 0xFFFFFFFF;
        } else {
            minute = in.readByte();
            if (minute < 0) {
                minute ^= 0xFFFFFFFF;
            } else {
                second = in.readByte();
                if (second < 0) {
                    second ^= 0xFFFFFFFF;
                } else {
                    nano = in.readInt();
                }
            }
        }
        return LocalTime.of(hour, minute, second, nano);
    }

    private static LocalDateTime readLocalDateTime(DataInputStream in) throws IOException {
        LocalDate date = EntityReader.readLocalDate(in);
        LocalTime time = EntityReader.readLocalTime(in);
        return LocalDateTime.of(date, time);
    }

    public Object readObject(Class<?> fieldClazz) throws IOException {
        Object object = CloneHelper.newInstance(fieldClazz);
        Field[] fields = fieldClazz.getDeclaredFields();
        Arrays.sort(fields, new FlatProperties.FieldComparator());
        for (Field field : fields) {
            if (FieldUtils.isTransient(field) || FieldUtils.isStatic(field)) continue;
            if (!FieldUtils.isFinal(field)) {
                Class<Object> fieldClass = field.getType();
                if (fieldClass == Object.class && "id".equals(field.getName())) {
                    fieldClass = String.class;
                }
                Object value = this.read(fieldClass);
                try {
                    field.setAccessible(true);
                    field.set(object, value);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.read(object, field);
        }
        return object;
    }

    private void read(Object object, Field field) throws IOException {
        Class<?> fieldClazz = field.getType();
        Object value = null;
        try {
            value = field.get(object);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (value instanceof Set) {
            int asInt = this.dis.readInt();
            EnumUtils.fillSet(asInt, fieldClazz, (Set)value);
        } else if (value instanceof List) {
            int size = this.dis.readInt();
            List list = (List)value;
            Class<?> listClass = GenericUtils.getGenericClass(field.getGenericType());
            if (list instanceof ArrayList) {
                ((ArrayList)list).ensureCapacity(size);
            }
            for (int i = 0; i < size; ++i) {
                list.add(this.read(listClass));
            }
        } else {
            Object readValue = this.read(fieldClazz);
            CloneHelper.deepCopy(readValue, value);
        }
    }

    private String readString() throws IOException {
        int chunks = this.dis.read();
        return this.readString(chunks);
    }

    private String readString(int chunks) throws IOException {
        if (chunks == 0) {
            return null;
        }
        int chunkSize = 20000;
        StringBuilder s = new StringBuilder((chunks + 1) * chunkSize);
        for (int i = 0; i < chunks; ++i) {
            s.append(this.dis.readUTF());
        }
        return s.toString();
    }

    public Object read() throws IOException {
        String className = this.readString();
        if (className != null) {
            try {
                return this.read(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new LoggingRuntimeException(e, logger, "readArguments failed");
            }
        }
        return null;
    }
}

