/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.transaction;

import java.lang.annotation.Annotation;
import org.minimalj.backend.repository.EntityTransaction;
import org.minimalj.transaction.Isolation;
import org.minimalj.transaction.Role;
import org.minimalj.transaction.Transaction;

public class TransactionAnnotations {
    public static Isolation.Level getIsolation(Transaction<?> transaction) {
        Isolation isolation = TransactionAnnotations.getAnnotation(transaction, Isolation.class);
        return isolation != null ? isolation.value() : Isolation.Level.SERIALIZABLE;
    }

    public static String[] getRoles(Transaction<?> transaction) {
        Role role = TransactionAnnotations.getAnnotation(transaction, Role.class);
        return role != null ? role.value() : null;
    }

    private static <A extends Annotation> A getAnnotation(Transaction<?> transaction, Class<A> annotationClass) {
        A annotation = transaction.getClass().getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        annotation = transaction.getClass().getPackage().getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (transaction instanceof EntityTransaction) {
            EntityTransaction entityTransaction = (EntityTransaction)transaction;
            annotation = entityTransaction.getEntityClazz().getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
            annotation = entityTransaction.getEntityClazz().getPackage().getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
        }
        return null;
    }
}

