/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Subject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final InheritableThreadLocal<Subject> subject = new InheritableThreadLocal();
    private String name;
    private Serializable token;
    private final List<String> roles = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Serializable getToken() {
        return this.token;
    }

    public void setToken(Serializable token) {
        this.token = token;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String ... roleNames) {
        for (String roleName : roleNames) {
            if (!this.roles.contains(roleName)) continue;
            return true;
        }
        return false;
    }

    public static boolean currentHasRole(String ... roleNames) {
        Subject currentSubject = Subject.getCurrent();
        return currentSubject != null ? currentSubject.hasRole(roleNames) : false;
    }

    public static void setCurrent(Subject subject) {
        Subject.subject.set(subject);
    }

    public static Subject getCurrent() {
        return (Subject)subject.get();
    }
}

