/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.minimalj.model.Code;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.Searched;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.list.RelationCriteria;
import org.minimalj.repository.query.AllCriteria;
import org.minimalj.repository.query.Criteria;
import org.minimalj.repository.query.FieldCriteria;
import org.minimalj.repository.query.Limit;
import org.minimalj.repository.query.Order;
import org.minimalj.repository.query.Query;
import org.minimalj.repository.query.SearchCriteria;
import org.minimalj.repository.sql.AbstractTable;
import org.minimalj.repository.sql.CrossTable;
import org.minimalj.repository.sql.HistorizedTable;
import org.minimalj.repository.sql.ListTable;
import org.minimalj.repository.sql.SqlDialect;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.repository.sql.SubTable;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LoggingRuntimeException;

public class Table<T>
extends AbstractTable<T> {
    private static final List<Object> EMPTY_WHERE_CLAUSE = Collections.singletonList("1=1");
    protected final PropertyInterface idProperty;
    protected final boolean optimisticLocking;
    protected final String selectAllQuery;
    protected final HashMap<PropertyInterface, ListTable> lists;

    public Table(SqlRepository sqlRepository, Class<T> clazz) {
        this(sqlRepository, null, clazz);
    }

    public Table(SqlRepository sqlRepository, String name, Class<T> clazz) {
        super(sqlRepository, name, clazz);
        this.idProperty = FlatProperties.getProperty(clazz, "id", true);
        Objects.nonNull(this.idProperty);
        this.optimisticLocking = FieldUtils.hasValidVersionfield(clazz);
        List<PropertyInterface> lists = FlatProperties.getListProperties(clazz);
        this.lists = this.createListTables(lists);
        this.selectAllQuery = this.selectAllQuery();
    }

    @Override
    public void createTable(SqlDialect dialect) {
        super.createTable(dialect);
        for (ListTable object : this.lists.values()) {
            AbstractTable subTable = (AbstractTable)((Object)object);
            subTable.createTable(dialect);
        }
    }

    @Override
    public void createIndexes(SqlDialect dialect) {
        super.createIndexes(dialect);
        for (ListTable object : this.lists.values()) {
            AbstractTable subTable = (AbstractTable)((Object)object);
            subTable.createIndexes(dialect);
        }
    }

    @Override
    public void createConstraints(SqlDialect dialect) {
        super.createConstraints(dialect);
        for (ListTable object : this.lists.values()) {
            AbstractTable subTable = (AbstractTable)((Object)object);
            subTable.createConstraints(dialect);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object insert(T object) {
        try (PreparedStatement insertStatement = Table.createStatement(this.sqlRepository.getConnection(), this.insertQuery, true);){
            Object id;
            if (IdUtils.hasId(object.getClass())) {
                id = IdUtils.getId(object);
                if (id == null) {
                    id = IdUtils.createId();
                    IdUtils.setId(object, id);
                }
            } else {
                id = IdUtils.createId();
            }
            this.setParameters(insertStatement, object, false, AbstractTable.ParameterMode.INSERT, id);
            insertStatement.execute();
            this.insertLists(object);
            if (object instanceof Code) {
                this.sqlRepository.invalidateCodeCache(object.getClass());
            }
            Object object2 = id;
            return object2;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't insert in " + this.getTableName() + " with " + object);
        }
    }

    protected void insertLists(T object) {
        for (Map.Entry<PropertyInterface, ListTable> listEntry : this.lists.entrySet()) {
            List list = (List)listEntry.getKey().getValue(object);
            if (list == null || list.isEmpty()) continue;
            listEntry.getValue().addList(object, list);
        }
    }

    public void delete(Object id) {
        try (PreparedStatement updateStatement = Table.createStatement(this.sqlRepository.getConnection(), this.deleteQuery, false);){
            updateStatement.setObject(1, id);
            updateStatement.execute();
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't delete " + this.getTableName() + " with ID " + id);
        }
    }

    private LinkedHashMap<PropertyInterface, ListTable> createListTables(List<PropertyInterface> listProperties) {
        LinkedHashMap<PropertyInterface, ListTable> lists = new LinkedHashMap<PropertyInterface, ListTable>();
        for (PropertyInterface listProperty : listProperties) {
            ListTable listTable = this.createListTable(listProperty);
            lists.put(listProperty, listTable);
        }
        return lists;
    }

    ListTable createListTable(PropertyInterface property) {
        Class<?> elementClass = GenericUtils.getGenericClass(property.getType());
        String subTableName = this.buildSubTableName(property);
        if (IdUtils.hasId(elementClass)) {
            return new CrossTable(this.sqlRepository, subTableName, elementClass, this.idProperty);
        }
        return new SubTable(this.sqlRepository, subTableName, elementClass, this.idProperty);
    }

    protected String buildSubTableName(PropertyInterface property) {
        return this.getTableName() + "__" + property.getName();
    }

    public void update(T object) {
        this.updateWithId(object, IdUtils.getId(object));
    }

    void updateWithId(T object, Object id) {
        try (PreparedStatement updateStatement = Table.createStatement(this.sqlRepository.getConnection(), this.updateQuery, false);){
            int parameterIndex = this.setParameters(updateStatement, object, false, AbstractTable.ParameterMode.UPDATE, id);
            if (this.optimisticLocking) {
                updateStatement.setInt(parameterIndex, IdUtils.getVersion(object));
                updateStatement.execute();
                if (updateStatement.getUpdateCount() == 0) {
                    throw new IllegalStateException("Optimistic locking failed");
                }
            } else {
                updateStatement.execute();
            }
            for (Map.Entry<PropertyInterface, ListTable> listTableEntry : this.lists.entrySet()) {
                List list = (List)listTableEntry.getKey().getValue(object);
                listTableEntry.getValue().replaceList(object, list);
            }
            if (object instanceof Code) {
                this.sqlRepository.invalidateCodeCache(object.getClass());
            }
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't update in " + this.getTableName() + " with " + object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(Object id) {
        try (PreparedStatement selectByIdStatement = Table.createStatement(this.sqlRepository.getConnection(), this.selectByIdQuery, false);){
            selectByIdStatement.setObject(1, id);
            Object object = this.executeSelect(selectByIdStatement);
            if (object != null) {
                this.loadLists(object);
            }
            Object t = object;
            return t;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't read " + this.getTableName() + " with ID " + id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(Object id, Map<Class<?>, Map<Object, Object>> loadedReferences) {
        try (PreparedStatement selectByIdStatement = Table.createStatement(this.sqlRepository.getConnection(), this.selectByIdQuery, false);){
            selectByIdStatement.setObject(1, id);
            Object object = this.executeSelect(selectByIdStatement, loadedReferences);
            if (object != null) {
                this.loadLists(object);
            }
            Object t = object;
            return t;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't read " + this.getTableName() + " with ID " + id);
        }
    }

    private List<String> getColumns(Object[] keys) {
        PropertyInterface[] properties;
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyInterface p : properties = Keys.getProperties(keys)) {
            if (p instanceof Keys.MethodProperty) {
                throw new IllegalArgumentException("Not possible to query for method properties");
            }
            if (p.getPath().equals("id")) {
                result.add("id");
                continue;
            }
            for (Map.Entry entry : this.columns.entrySet()) {
                PropertyInterface property = (PropertyInterface)entry.getValue();
                if (!p.getPath().equals(property.getPath())) continue;
                result.add((String)entry.getKey());
            }
        }
        return result;
    }

    public List<Object> whereClause(Query query) {
        List<Object> result;
        if (query instanceof Criteria.AndCriteria) {
            Criteria.AndCriteria andCriteria = (Criteria.AndCriteria)query;
            result = this.combine(andCriteria.getCriterias(), "AND");
        } else if (query instanceof Criteria.OrCriteria) {
            Criteria.OrCriteria orCriteria = (Criteria.OrCriteria)query;
            result = this.combine(orCriteria.getCriterias(), "OR");
        } else if (query instanceof FieldCriteria) {
            FieldCriteria fieldCriteria = (FieldCriteria)query;
            result = new ArrayList<Object>();
            Object value = fieldCriteria.getValue();
            String term = this.whereStatement(fieldCriteria.getPath(), fieldCriteria.getOperator());
            if (value != null && IdUtils.hasId(value.getClass())) {
                value = IdUtils.getId(value);
            }
            result.add(term);
            result.add(value);
        } else if (query instanceof SearchCriteria) {
            SearchCriteria searchCriteria = (SearchCriteria)query;
            result = new ArrayList<Object>();
            String search = this.convertUserSearch(searchCriteria.getQuery());
            String clause = "(";
            List<String> searchColumns = searchCriteria.getKeys() != null ? this.getColumns(searchCriteria.getKeys()) : this.findSearchColumns(this.clazz);
            boolean first = true;
            for (String column : searchColumns) {
                if (!first) {
                    clause = clause + " OR ";
                } else {
                    first = false;
                }
                clause = clause + column + (searchCriteria.isNotEqual() ? " NOT" : "") + " LIKE ?";
                result.add(search);
            }
            clause = this instanceof HistorizedTable ? clause + ") and historized = 0" : clause + ")";
            result.add(0, clause);
        } else if (query instanceof RelationCriteria) {
            RelationCriteria relationCriteria = (RelationCriteria)query;
            result = new ArrayList<Object>();
            String crossTableName = relationCriteria.getCrossName();
            this.avoidSqlInjection(crossTableName);
            String clause = "T.id = C.elementId AND C.id = ? ORDER BY C.position";
            result.add(clause);
            result.add(relationCriteria.getRelatedId());
        } else if (query instanceof Limit) {
            Limit limit = (Limit)query;
            result = this.whereClause(limit.getQuery());
            String s = (String)result.get(0);
            s = s + " " + this.sqlRepository.getSqlDialect().limit(limit.getRows(), limit.getOffset());
            result.set(0, s);
        } else if (query instanceof Order) {
            Order order = (Order)query;
            ArrayList<Order> orders = new ArrayList<Order>();
            orders.add(order);
            while (order.getQuery() instanceof Order) {
                order = (Order)order.getQuery();
                orders.add(order);
            }
            result = this.whereClause(order.getQuery());
            String s = (String)result.get(0);
            s = s + " " + this.order(orders);
            result.set(0, s);
        } else if (query instanceof AllCriteria) {
            result = new ArrayList<Object>(EMPTY_WHERE_CLAUSE);
        } else if (query == null) {
            result = EMPTY_WHERE_CLAUSE;
        } else {
            throw new IllegalArgumentException("Unknown criteria: " + query);
        }
        return result;
    }

    private void avoidSqlInjection(String crossTableName) {
        if (!this.sqlRepository.getTableByName().containsKey(crossTableName)) {
            throw new IllegalArgumentException("Invalid cross name: " + crossTableName);
        }
    }

    private String order(List<Order> orders) {
        StringBuilder s = new StringBuilder();
        for (Order order : orders) {
            if (s.length() == 0) {
                s.append("ORDER BY ");
            } else {
                s.append(", ");
            }
            s.append(this.findColumn(order.getPath()));
            if (order.isAscending()) continue;
            s.append(" DESC");
        }
        return s.toString();
    }

    private List<Object> combine(List<? extends Query> criterias, String operator) {
        if (criterias.isEmpty()) {
            return null;
        }
        if (criterias.size() == 1) {
            return this.whereClause(criterias.get(0));
        }
        List<Object> whereClause = this.whereClause(criterias.get(0));
        String clause = "(" + whereClause.get(0);
        for (int i = 1; i < criterias.size(); ++i) {
            List<Object> whereClause2 = this.whereClause(criterias.get(i));
            clause = clause + " " + operator + " " + whereClause2.get(0);
            if (whereClause2.size() <= 1) continue;
            whereClause.addAll(whereClause2.subList(1, whereClause2.size()));
        }
        clause = clause + ")";
        whereClause.set(0, clause);
        return whereClause;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long count(Query query) {
        List<Object> whereClause;
        String tableName;
        if ((query = this.getCriteria(query)) instanceof RelationCriteria) {
            RelationCriteria relationCriteria = (RelationCriteria)query;
            tableName = relationCriteria.getCrossName();
            this.avoidSqlInjection(tableName);
            whereClause = Arrays.asList("id = ?", relationCriteria.getRelatedId());
        } else {
            tableName = this.getTableName();
            whereClause = this.whereClause(query);
        }
        String queryString = "SELECT COUNT(*) FROM " + tableName + (whereClause != EMPTY_WHERE_CLAUSE ? " WHERE " + whereClause.get(0) : "");
        try (PreparedStatement statement = Table.createStatement(this.sqlRepository.getConnection(), queryString, false);){
            for (int i = 1; i < whereClause.size(); ++i) {
                this.sqlRepository.getSqlDialect().setParameter(statement, i, whereClause.get(i), null);
            }
            long l = this.executeSelectCount(statement);
            return l;
        }
        catch (SQLException e) {
            throw new LoggingRuntimeException(e, sqlLogger, "count failed");
        }
    }

    private Query getCriteria(Query query) {
        if (query instanceof Limit) {
            query = ((Limit)query).getQuery();
        }
        while (query instanceof Order) {
            query = ((Order)query).getQuery();
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S> List<S> find(Query query, Class<S> resultClass) {
        List<Object> whereClause = this.whereClause(query);
        String select = this.getCriteria(query) instanceof RelationCriteria ? this.select(resultClass, (RelationCriteria)this.getCriteria(query)) : this.select(resultClass);
        String queryString = select + (whereClause != EMPTY_WHERE_CLAUSE ? " WHERE " + whereClause.get(0) : "");
        try (PreparedStatement statement = Table.createStatement(this.sqlRepository.getConnection(), queryString, false);){
            for (int i = 1; i < whereClause.size(); ++i) {
                this.sqlRepository.getSqlDialect().setParameter(statement, i, whereClause.get(i), null);
            }
            List<Object> list = resultClass == this.getClazz() ? this.executeSelectAll(statement) : this.executeSelectViewAll(resultClass, statement);
            return list;
        }
        catch (SQLException e) {
            throw new LoggingRuntimeException(e, sqlLogger, "read with SimpleCriteria failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S> S readView(Class<S> resultClass, Object id, Map<Class<?>, Map<Object, Object>> loadedReferences) {
        String query = this.select(resultClass) + " WHERE id = ?";
        try (PreparedStatement statement = Table.createStatement(this.sqlRepository.getConnection(), query, false);){
            statement.setObject(1, id);
            S s = this.executeSelectView(resultClass, statement, loadedReferences);
            return s;
        }
        catch (SQLException e) {
            throw new LoggingRuntimeException(e, sqlLogger, "read with SimpleCriteria failed");
        }
    }

    private String select(Class<?> resultClass) {
        String querySql = "SELECT ";
        if (resultClass == this.getClazz()) {
            querySql = querySql + "*";
        } else {
            querySql = querySql + "id";
            LinkedHashMap<String, PropertyInterface> propertiesByColumns = this.sqlRepository.findColumns(resultClass);
            for (String column : propertiesByColumns.keySet()) {
                querySql = querySql + ", " + column;
            }
        }
        querySql = querySql + " FROM " + this.getTableName();
        return querySql;
    }

    private String select(Class<?> resultClass, RelationCriteria relationCriteria) {
        String crossTableName = relationCriteria.getCrossName();
        String querySql = "SELECT ";
        if (resultClass == this.getClazz()) {
            querySql = querySql + "T.*";
        } else {
            querySql = querySql + "T.id";
            LinkedHashMap<String, PropertyInterface> propertiesByColumns = this.sqlRepository.findColumns(resultClass);
            for (String column : propertiesByColumns.keySet()) {
                querySql = querySql + ", T." + column;
            }
        }
        querySql = querySql + " FROM " + this.getTableName() + " T, " + crossTableName + " C";
        return querySql;
    }

    protected <S> List<S> executeSelectViewAll(Class<S> resultClass, PreparedStatement preparedStatement) throws SQLException {
        ArrayList<S> result = new ArrayList<S>();
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            HashMap loadedReferences = new HashMap();
            while (resultSet.next()) {
                S resultObject = this.sqlRepository.readResultSetRow(resultClass, resultSet, loadedReferences);
                result.add(resultObject);
                List<PropertyInterface> viewLists = FlatProperties.getListProperties(resultClass);
                block10: for (PropertyInterface viewListProperty : viewLists) {
                    for (Map.Entry<PropertyInterface, ListTable> listPropertyEntry : this.lists.entrySet()) {
                        if (!viewListProperty.getPath().equals(listPropertyEntry.getKey().getPath())) continue;
                        List values = listPropertyEntry.getValue().getList(resultObject);
                        PropertyInterface listProperty = listPropertyEntry.getKey();
                        listProperty.setValue(resultObject, values);
                        continue block10;
                    }
                }
            }
        }
        return result;
    }

    protected <S> S executeSelectView(Class<S> resultClass, PreparedStatement preparedStatement, Map<Class<?>, Map<Object, Object>> loadedReferences) throws SQLException {
        S result = null;
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                result = this.sqlRepository.readResultSetRow(resultClass, resultSet, loadedReferences);
            }
        }
        return result;
    }

    public String convertUserSearch(String s) {
        s = s.replace('*', '%');
        return s;
    }

    private List<String> findSearchColumns(Class<?> clazz) {
        ArrayList<String> searchColumns = new ArrayList<String>();
        for (Map.Entry entry : this.columns.entrySet()) {
            PropertyInterface property = (PropertyInterface)entry.getValue();
            Searched searchable = property.getAnnotation(Searched.class);
            if (searchable == null) continue;
            searchColumns.add((String)entry.getKey());
        }
        if (searchColumns.isEmpty()) {
            throw new IllegalArgumentException("No fields are annotated as 'Searched' in " + clazz.getName());
        }
        return searchColumns;
    }

    protected void loadLists(T object) throws SQLException {
        for (Map.Entry<PropertyInterface, ListTable> listTableEntry : this.lists.entrySet()) {
            List values = listTableEntry.getValue().getList(object);
            PropertyInterface listProperty = listTableEntry.getKey();
            listProperty.setValue(object, values);
        }
    }

    @Override
    protected String selectByIdQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName()).append(" WHERE id = ?");
        return query.toString();
    }

    protected String selectAllQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName());
        return query.toString();
    }

    @Override
    protected String insertQuery() {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ").append(this.getTableName()).append(" (");
        for (String columnName : this.getColumns().keySet()) {
            s.append(columnName).append(", ");
        }
        s.append("id) VALUES (");
        for (int i = 0; i < this.getColumns().size(); ++i) {
            s.append("?, ");
        }
        s.append("?)");
        return s.toString();
    }

    @Override
    protected String updateQuery() {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE ").append(this.getTableName()).append(" SET ");
        for (String columnNameObject : this.getColumns().keySet()) {
            s.append(columnNameObject).append("= ?, ");
        }
        boolean optimisticLocking = FieldUtils.hasValidVersionfield(this.clazz);
        if (optimisticLocking) {
            s.append(" version = version + 1 WHERE id = ? AND version = ?");
        } else {
            s.delete(s.length() - 2, s.length());
            s.append(" WHERE id = ?");
        }
        return s.toString();
    }

    @Override
    protected String deleteQuery() {
        StringBuilder s = new StringBuilder();
        s.append("DELETE FROM ").append(this.getTableName()).append(" WHERE id = ?");
        return s.toString();
    }

    @Override
    protected void addSpecialColumns(SqlDialect dialect, StringBuilder s) {
        if (this.idProperty != null) {
            dialect.addIdColumn(s, this.idProperty);
        } else {
            dialect.addIdColumn(s, Object.class, 36);
        }
        if (this.optimisticLocking) {
            s.append(",\n version INTEGER DEFAULT 0");
        }
    }

    @Override
    protected void addPrimaryKey(SqlDialect dialect, StringBuilder s) {
        dialect.addPrimaryKey(s, "id");
    }
}

