/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.sql.AbstractTable;
import org.minimalj.repository.sql.ListTable;
import org.minimalj.repository.sql.SqlDialect;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LoggingRuntimeException;

public class SubTable<PARENT, ELEMENT>
extends AbstractTable<ELEMENT>
implements ListTable<PARENT, ELEMENT> {
    protected final PropertyInterface parentIdProperty;

    public SubTable(SqlRepository sqlRepository, String name, Class<ELEMENT> clazz, PropertyInterface parentIdProperty) {
        super(sqlRepository, name, clazz);
        this.parentIdProperty = parentIdProperty;
    }

    @Override
    public void addList(PARENT parent, List<ELEMENT> objects) {
        try (PreparedStatement insertStatement = SubTable.createStatement(this.sqlRepository.getConnection(), this.insertQuery, false);){
            for (int position = 0; position < objects.size(); ++position) {
                ELEMENT object = objects.get(position);
                int parameterPos = this.setParameters(insertStatement, object, false, AbstractTable.ParameterMode.INSERT, IdUtils.getId(parent));
                insertStatement.setInt(parameterPos++, position);
                insertStatement.execute();
            }
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "addList failed");
        }
    }

    @Override
    public void replaceList(PARENT parent, List<ELEMENT> objects) {
        Object parentId = IdUtils.getId(parent);
        List<ELEMENT> objectsInDb = this.getList(parent);
        try {
            for (int position = 0; position < Math.max(objects.size(), objectsInDb.size()); ++position) {
                if (position < objects.size()) {
                    Object object = objects.get(position);
                    if (IdUtils.getId(object) == null) {
                        object = this.sqlRepository.insert(object);
                    }
                    if (position < objectsInDb.size()) {
                        this.update(parentId, position, objects.get(position));
                        continue;
                    }
                    this.insert(parentId, position, objects.get(position));
                    continue;
                }
                this.delete(parentId, position);
                break;
            }
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "replaceList failed");
        }
    }

    protected void update(Object parentId, int position, ELEMENT object) throws SQLException {
        try (PreparedStatement updateStatement = SubTable.createStatement(this.sqlRepository.getConnection(), this.updateQuery, false);){
            int parameterPos = this.setParameters(updateStatement, object, false, AbstractTable.ParameterMode.UPDATE, parentId);
            updateStatement.setInt(parameterPos++, position);
            updateStatement.execute();
        }
    }

    protected void insert(Object parentId, int position, ELEMENT object) throws SQLException {
        try (PreparedStatement insertStatement = SubTable.createStatement(this.sqlRepository.getConnection(), this.insertQuery, false);){
            int parameterPos = this.setParameters(insertStatement, object, false, AbstractTable.ParameterMode.INSERT, parentId);
            insertStatement.setInt(parameterPos++, position);
            insertStatement.execute();
        }
    }

    protected void delete(Object parentId, int position) throws SQLException {
        try (PreparedStatement deleteStatement = SubTable.createStatement(this.sqlRepository.getConnection(), this.deleteQuery, false);){
            deleteStatement.setObject(1, parentId);
            deleteStatement.setInt(2, position);
            deleteStatement.execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ELEMENT> getList(PARENT parent) {
        try (PreparedStatement selectByIdStatement = SubTable.createStatement(this.sqlRepository.getConnection(), this.selectByIdQuery, false);){
            selectByIdStatement.setObject(1, IdUtils.getId(parent));
            List list = this.executeSelectAll(selectByIdStatement);
            return list;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "getList failed");
        }
    }

    @Override
    protected String selectByIdQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName()).append(" WHERE id = ? ORDER BY position");
        return query.toString();
    }

    @Override
    protected String insertQuery() {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ").append(this.getTableName()).append(" (");
        Iterator<String> iterator = this.getColumns().keySet().iterator();
        while (iterator.hasNext()) {
            String columnNameObject;
            String columnName = columnNameObject = iterator.next();
            s.append(columnName).append(", ");
        }
        s.append("id, position) VALUES (");
        for (int i = 0; i < this.getColumns().size(); ++i) {
            s.append("?, ");
        }
        s.append("?, ?)");
        return s.toString();
    }

    @Override
    protected String updateQuery() {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE ").append(this.getTableName()).append(" SET ");
        for (String columnNameObject : this.getColumns().keySet()) {
            s.append(columnNameObject).append("= ?, ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(" WHERE id = ? AND position = ?");
        return s.toString();
    }

    @Override
    protected String deleteQuery() {
        return "DELETE FROM " + this.getTableName() + " WHERE id = ? AND position >= ?";
    }

    @Override
    protected void addSpecialColumns(SqlDialect dialect, StringBuilder s) {
        s.append(" id ");
        dialect.addColumnDefinition(s, this.parentIdProperty);
        s.append(",\n position INTEGER NOT NULL");
    }

    @Override
    protected void addPrimaryKey(SqlDialect dialect, StringBuilder s) {
        dialect.addPrimaryKey(s, "id, position");
    }
}

