/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.minimalj.application.Configuration;
import org.minimalj.model.Code;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.Keys;
import org.minimalj.model.View;
import org.minimalj.model.ViewUtil;
import org.minimalj.model.properties.ChainedProperty;
import org.minimalj.model.properties.FieldProperty;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.test.ModelTest;
import org.minimalj.repository.Repository;
import org.minimalj.repository.TransactionalRepository;
import org.minimalj.repository.list.QueryResultList;
import org.minimalj.repository.query.AllCriteria;
import org.minimalj.repository.query.By;
import org.minimalj.repository.query.Limit;
import org.minimalj.repository.query.Query;
import org.minimalj.repository.sql.AbstractTable;
import org.minimalj.repository.sql.HistorizedTable;
import org.minimalj.repository.sql.SqlDialect;
import org.minimalj.repository.sql.SqlIdentifier;
import org.minimalj.repository.sql.Table;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.Codes;
import org.minimalj.util.CsvReader;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LoggingRuntimeException;
import org.minimalj.util.StringUtils;

public class SqlRepository
implements TransactionalRepository {
    private static final Logger logger = Logger.getLogger(SqlRepository.class.getName());
    public static final boolean CREATE_TABLES = true;
    private final SqlDialect sqlDialect;
    private final Map<Class<?>, AbstractTable<?>> tables = new LinkedHashMap();
    private final Map<String, AbstractTable<?>> tableByName = new HashMap();
    private final Map<Class<?>, LinkedHashMap<String, PropertyInterface>> columnsForClass = new HashMap(200);
    private final DataSource dataSource;
    private Connection autoCommitConnection;
    private final BlockingDeque<Connection> connectionDeque = new LinkedBlockingDeque<Connection>();
    private final ThreadLocal<Connection> threadLocalTransactionConnection = new ThreadLocal();
    private final HashMap<Class<? extends Code>, Codes.CodeCacheItem<? extends Code>> codeCache = new HashMap();

    public SqlRepository(DataSource dataSource, Class<?> ... classes) {
        this(dataSource, SqlRepository.createTablesOnInitialize(dataSource), classes);
    }

    public SqlRepository(DataSource dataSource, boolean createTablesOnInitialize, Class<?> ... classes) {
        this.dataSource = dataSource;
        Connection connection = this.getAutoCommitConnection();
        try {
            this.sqlDialect = this.findDialect(connection);
            for (Class<?> clazz : classes) {
                this.addClass(clazz);
            }
            new ModelTest(classes).assertValid();
            if (createTablesOnInitialize) {
                this.createTables();
                this.createCodes();
            }
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, logger, "Could not determine product name of database");
        }
    }

    private SqlDialect findDialect(Connection connection) throws SQLException {
        if (Configuration.available("MjSqlDialect")) {
            return Configuration.getClazz("MjSqlDialect", SqlDialect.class, new Object[0]);
        }
        String databaseProductName = connection.getMetaData().getDatabaseProductName();
        if (StringUtils.equals(databaseProductName, "MySQL")) {
            return new SqlDialect.MariaSqlDialect();
        }
        if (StringUtils.equals(databaseProductName, "Apache Derby")) {
            return new SqlDialect.DerbySqlDialect();
        }
        if (StringUtils.equals(databaseProductName, "H2")) {
            return new SqlDialect.H2SqlDialect();
        }
        if (StringUtils.equals(databaseProductName, "Oracle")) {
            return new SqlDialect.OracleSqlDialect();
        }
        throw new RuntimeException("Only Oracle, H2, MySQL/MariaDB and Derby DB supported at the moment. ProductName: " + databaseProductName);
    }

    private Connection getAutoCommitConnection() {
        try {
            if (this.autoCommitConnection == null || !this.autoCommitConnection.isValid(0)) {
                this.autoCommitConnection = this.dataSource.getConnection();
                this.autoCommitConnection.setAutoCommit(true);
            }
            return this.autoCommitConnection;
        }
        catch (Exception e) {
            throw new LoggingRuntimeException(e, logger, "Not possible to create autocommit connection");
        }
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void startTransaction(int transactionIsolationLevel) {
        if (this.isTransactionActive()) {
            return;
        }
        Connection transactionConnection = this.allocateConnection(transactionIsolationLevel);
        this.threadLocalTransactionConnection.set(transactionConnection);
    }

    @Override
    public void endTransaction(boolean commit) {
        Connection transactionConnection = this.threadLocalTransactionConnection.get();
        if (transactionConnection == null) {
            return;
        }
        try {
            if (commit) {
                transactionConnection.commit();
            } else {
                transactionConnection.rollback();
            }
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, logger, "Transaction failed");
        }
        this.releaseConnection(transactionConnection);
        this.threadLocalTransactionConnection.set(null);
    }

    private Connection allocateConnection(int transactionIsolationLevel) {
        Connection connection = this.connectionDeque.poll();
        while (true) {
            boolean valid = false;
            try {
                valid = connection != null && connection.isValid(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (valid) {
                return connection;
            }
            try {
                connection = this.dataSource.getConnection();
                connection.setTransactionIsolation(transactionIsolationLevel);
                connection.setAutoCommit(false);
                return connection;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.FINE, "Not possible to create additional connection", e);
                try {
                    this.connectionDeque.poll(10L, TimeUnit.SECONDS);
                    continue;
                }
                catch (InterruptedException e2) {
                    logger.log(Level.FINEST, "poll for connection interrupted", e2);
                    continue;
                }
            }
            break;
        }
    }

    private void releaseConnection(Connection connection) {
        this.connectionDeque.push(connection);
    }

    public void clear() {
        ArrayList tableList = new ArrayList(this.tables.values());
        for (AbstractTable abstractTable : tableList) {
            abstractTable.clear();
        }
    }

    public boolean isTransactionActive() {
        Connection connection = this.threadLocalTransactionConnection.get();
        return connection != null;
    }

    Connection getConnection() {
        Connection connection = this.threadLocalTransactionConnection.get();
        if (connection != null) {
            return connection;
        }
        connection = this.getAutoCommitConnection();
        return connection;
    }

    private static boolean createTablesOnInitialize(DataSource dataSource) {
        if (StringUtils.equals(dataSource.getClass().getName(), "org.apache.derby.jdbc.EmbeddedDataSource")) {
            return "create".equals(((EmbeddedDataSource)dataSource).getCreateDatabase());
        }
        if (StringUtils.equals(dataSource.getClass().getName(), "org.h2.jdbcx.JdbcDataSource")) {
            return ((JdbcDataSource)dataSource).getUrl().startsWith("jdbc:h2:mem:TempDB");
        }
        return false;
    }

    @Override
    public <T> T read(Class<T> clazz, Object id) {
        Table<T> table = this.getTable(clazz);
        return table.read(id);
    }

    public <T> T readVersion(Class<T> clazz, Object id, Integer time) {
        HistorizedTable table = (HistorizedTable)this.getTable(clazz);
        return table.read(id, time);
    }

    @Override
    public <T> List<T> find(Class<T> resultClass, Query query) {
        if (query instanceof Limit || query instanceof AllCriteria) {
            Table<Object> table;
            if (View.class.isAssignableFrom(resultClass)) {
                Class<?> viewedClass = ViewUtil.getViewedClass(resultClass);
                table = this.getTable(viewedClass);
            } else {
                table = this.getTable(resultClass);
            }
            return table.find(query, resultClass);
        }
        return new SqlQueryResultList<T>(this, resultClass, (Query.QueryLimitable)query);
    }

    @Override
    public <T> long count(Class<T> clazz, Query query) {
        if (View.class.isAssignableFrom(clazz)) {
            clazz = ViewUtil.getViewedClass(clazz);
        }
        Table<T> table = this.getTable(clazz);
        return table.count(query);
    }

    @Override
    public <T> Object insert(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Table<?> table = this.getTable(object.getClass());
        return table.insert(object);
    }

    @Override
    public <T> void update(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Table<?> table = this.getTable(object.getClass());
        table.update(object);
    }

    public <T> void delete(T object) {
        this.delete(object.getClass(), IdUtils.getId(object));
    }

    @Override
    public <T> void delete(Class<T> clazz, Object id) {
        Table<T> table = this.getTable(clazz);
        table.delete(id);
    }

    public <T> void deleteAll(Class<T> clazz) {
        Table<T> table = this.getTable(clazz);
        table.clear();
    }

    public <T> List<T> loadHistory(Class<?> clazz, Object id, int maxResult) {
        Table<?> table = this.getTable(clazz);
        if (table instanceof HistorizedTable) {
            HistorizedTable historizedTable = (HistorizedTable)table;
            int maxVersion = historizedTable.getMaxVersion(id);
            int maxResults = Math.min(maxVersion + 1, maxResult);
            ArrayList result = new ArrayList(maxResults);
            for (int i = 0; i < maxResults; ++i) {
                result.add(historizedTable.read(id, maxVersion - i));
            }
            return result;
        }
        throw new IllegalArgumentException(clazz.getSimpleName() + " is not historized");
    }

    private PreparedStatement createStatement(Connection connection, String query, Object[] parameters) throws SQLException {
        PreparedStatement preparedStatement = AbstractTable.createStatement(this.getConnection(), query, false);
        int param = 1;
        for (Object parameter : parameters) {
            this.setParameter(preparedStatement, param++, parameter);
        }
        return preparedStatement;
    }

    public LinkedHashMap<String, PropertyInterface> findColumns(Class<?> clazz) {
        if (this.columnsForClass.containsKey(clazz)) {
            return this.columnsForClass.get(clazz);
        }
        LinkedHashMap<String, PropertyInterface> columns = new LinkedHashMap<String, PropertyInterface>();
        for (Field field : clazz.getFields()) {
            if (!FieldUtils.isPublic(field) || FieldUtils.isStatic(field) || FieldUtils.isTransient(field)) continue;
            String fieldName = StringUtils.toSnakeCase(field.getName()).toUpperCase();
            if (StringUtils.equals(fieldName, "ID", "VERSION", "HISTORIZED") || FieldUtils.isList(field)) continue;
            if (FieldUtils.isFinal(field) && !FieldUtils.isSet(field) && !Codes.isCode(field.getType())) {
                LinkedHashMap<String, PropertyInterface> inlinePropertys = this.findColumns(field.getType());
                boolean hasClassName = FieldUtils.hasClassName(field) && !FlatProperties.hasCollidingFields(clazz, field.getType(), field.getName());
                Iterator iterator = inlinePropertys.keySet().iterator();
                while (iterator.hasNext()) {
                    String inlineKey;
                    String key = inlineKey = (String)iterator.next();
                    if (!hasClassName) {
                        key = fieldName + "_" + inlineKey;
                    }
                    key = SqlIdentifier.buildIdentifier(key, this.getMaxIdentifierLength(), columns.keySet());
                    columns.put(key, new ChainedProperty(new FieldProperty(field), (PropertyInterface)inlinePropertys.get(inlineKey)));
                }
                continue;
            }
            fieldName = SqlIdentifier.buildIdentifier(fieldName, this.getMaxIdentifierLength(), columns.keySet());
            columns.put(fieldName, new FieldProperty(field));
        }
        this.columnsForClass.put(clazz, columns);
        return columns;
    }

    private void setParameter(PreparedStatement preparedStatement, int param, Object value) throws SQLException {
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            value = e.ordinal();
        } else if (value instanceof LocalDate) {
            value = Date.valueOf((LocalDate)value);
        } else if (value instanceof LocalTime) {
            value = Time.valueOf((LocalTime)value);
        } else if (value instanceof LocalDateTime) {
            value = Timestamp.valueOf((LocalDateTime)value);
        }
        preparedStatement.setObject(param, value);
    }

    /*
     * Exception decompiling
     */
    public <T> List<T> execute(Class<T> clazz, String query, int maxResults, Serializable ... parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <T> T execute(Class<T> clazz, String query, Serializable ... parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <R> R readResultSetRow(Class<R> clazz, ResultSet resultSet) throws SQLException {
        HashMap loadedReferences = new HashMap();
        return this.readResultSetRow(clazz, resultSet, loadedReferences);
    }

    public <R> R readResultSetRow(Class<R> clazz, ResultSet resultSet, Map<Class<?>, Map<Object, Object>> loadedReferences) throws SQLException {
        Object key;
        if (clazz == Integer.class) {
            return (R)Integer.valueOf(resultSet.getInt(1));
        }
        if (clazz == BigDecimal.class) {
            return (R)resultSet.getBigDecimal(1);
        }
        if (clazz == String.class) {
            return (R)resultSet.getString(1);
        }
        Object id = null;
        Integer position = 0;
        R result = CloneHelper.newInstance(clazz);
        LinkedHashMap<String, PropertyInterface> columns = this.findColumns(clazz);
        HashMap<PropertyInterface, byte[]> values = new HashMap<PropertyInterface, byte[]>(resultSet.getMetaData().getColumnCount() * 3);
        for (int columnIndex = 1; columnIndex <= resultSet.getMetaData().getColumnCount(); ++columnIndex) {
            Object value;
            String columnName = resultSet.getMetaData().getColumnName(columnIndex);
            if ("ID".equalsIgnoreCase(columnName)) {
                id = resultSet.getObject(columnIndex);
                IdUtils.setId(result, id);
                continue;
            }
            if ("VERSION".equalsIgnoreCase(columnName)) {
                IdUtils.setVersion(result, resultSet.getInt(columnIndex));
                continue;
            }
            if ("POSITION".equalsIgnoreCase(columnName)) {
                position = resultSet.getInt(columnIndex);
                continue;
            }
            if ("HISTORIZED".equalsIgnoreCase(columnName)) {
                IdUtils.setHistorized(result, resultSet.getInt(columnIndex));
                continue;
            }
            PropertyInterface property = columns.get(columnName);
            if (property == null) continue;
            Class<?> fieldClass = property.getClazz();
            boolean isByteArray = fieldClass.isArray() && fieldClass.getComponentType() == Byte.TYPE;
            Object object = value = isByteArray ? resultSet.getBytes(columnIndex) : (Object)resultSet.getObject(columnIndex);
            if (value == null) continue;
            values.put(property, (byte[])value);
        }
        if (!loadedReferences.containsKey(clazz)) {
            loadedReferences.put(clazz, new HashMap());
        }
        Object object = key = position == null ? id : id + "-" + position;
        if (loadedReferences.get(clazz).containsKey(key)) {
            return (R)loadedReferences.get(clazz).get(key);
        }
        loadedReferences.get(clazz).put(key, result);
        for (Map.Entry entry : values.entrySet()) {
            Object value = entry.getValue();
            PropertyInterface property = (PropertyInterface)entry.getKey();
            if (value == null) continue;
            Class<?> fieldClass = property.getClazz();
            if (Code.class.isAssignableFrom(fieldClass)) {
                Class<?> codeClass = fieldClass;
                value = this.getCode(codeClass, value);
            } else if (View.class.isAssignableFrom(fieldClass)) {
                Class<?> viewedClass = ViewUtil.getViewedClass(fieldClass);
                Table<?> referenceTable = this.getTable(viewedClass);
                value = referenceTable.readView(fieldClass, value, loadedReferences);
            } else if (IdUtils.hasId(fieldClass)) {
                if (loadedReferences.containsKey(fieldClass) && loadedReferences.get(fieldClass).containsKey(value)) {
                    value = loadedReferences.get(fieldClass).get(value);
                } else {
                    Table<?> referenceTable = this.getTable(fieldClass);
                    value = referenceTable.read(value, loadedReferences);
                }
            } else if (AbstractTable.isDependable(property)) {
                value = this.getTable(fieldClass).read(value);
            } else {
                if (fieldClass == Set.class) {
                    Set set = (Set)property.getValue(result);
                    Class<?> enumClass = GenericUtils.getGenericClass(property.getType());
                    EnumUtils.fillSet((Integer)value, enumClass, set);
                    continue;
                }
                value = this.sqlDialect.convertToFieldClass(fieldClass, value);
            }
            property.setValue(result, value);
        }
        return result;
    }

    <U> void addClass(Class<U> clazz) {
        if (!this.tables.containsKey(clazz)) {
            boolean historized = FieldUtils.hasValidHistorizedField(clazz);
            this.tables.put(clazz, null);
            Table table = historized ? new HistorizedTable<U>(this, clazz) : new Table<U>(this, clazz);
            this.tables.put(table.getClazz(), table);
        }
    }

    private void createTables() {
        ArrayList tableList = new ArrayList(this.tables.values());
        for (AbstractTable abstractTable : tableList) {
            abstractTable.createTable(this.sqlDialect);
        }
        for (AbstractTable abstractTable : tableList) {
            abstractTable.createIndexes(this.sqlDialect);
        }
        for (AbstractTable abstractTable : tableList) {
            abstractTable.createConstraints(this.sqlDialect);
        }
    }

    private void createCodes() {
        this.createConstantCodes();
        this.createCsvCodes();
    }

    private void createConstantCodes() {
        for (AbstractTable<?> table : this.tables.values()) {
            if (!Code.class.isAssignableFrom(table.getClazz())) continue;
            Class<?> codeClass = table.getClazz();
            List<Code> constants = Codes.getConstants(codeClass);
            for (Code code : constants) {
                ((Table)table).insert(code);
            }
        }
    }

    private void createCsvCodes() {
        ArrayList tableList = new ArrayList(this.tables.values());
        for (AbstractTable abstractTable : tableList) {
            Class clazz;
            InputStream is;
            if (!Code.class.isAssignableFrom(abstractTable.getClazz()) || (is = (clazz = abstractTable.getClazz()).getResourceAsStream(clazz.getSimpleName() + ".csv")) == null) continue;
            CsvReader reader = new CsvReader(is);
            List values = reader.readValues(clazz);
            for (Code value : values) {
                ((Table)abstractTable).insert(value);
            }
        }
    }

    public <U> AbstractTable<U> getAbstractTable(Class<U> clazz) {
        if (!this.tables.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz.getName());
        }
        return this.tables.get(clazz);
    }

    public <U> Table<U> getTable(Class<U> clazz) {
        AbstractTable<U> table = this.getAbstractTable(clazz);
        if (!(table instanceof Table)) {
            throw new IllegalArgumentException(clazz.getName());
        }
        return (Table)table;
    }

    public <U> Table<U> getTable(String className) {
        for (Map.Entry<Class<?>, AbstractTable<?>> entry : this.tables.entrySet()) {
            if (!entry.getKey().getName().equals(className)) continue;
            return (Table)entry.getValue();
        }
        return null;
    }

    public String name(Object classOrKey) {
        if (classOrKey instanceof Class) {
            return this.table((Class)classOrKey);
        }
        return this.column(classOrKey);
    }

    public String table(Class<?> clazz) {
        AbstractTable<?> table = this.getAbstractTable(clazz);
        return table.getTableName();
    }

    public String column(Object key) {
        PropertyInterface property = Keys.getProperty(key);
        Class<?> declaringClass = property.getDeclaringClass();
        AbstractTable<?> table = this.getAbstractTable(declaringClass);
        return table.column(property);
    }

    public boolean tableExists(Class<?> clazz) {
        return this.tables.containsKey(clazz);
    }

    public <T extends Code> T getCode(Class<T> clazz, Object codeId) {
        if (this.isLoading(clazz)) {
            return (T)((Code)this.getTable(clazz).read(codeId));
        }
        List<T> codes = this.getCodes(clazz);
        return Codes.findCode(codes, codeId);
    }

    private <T extends Code> boolean isLoading(Class<T> clazz) {
        Codes.CodeCacheItem<? extends Code> cacheItem = this.codeCache.get(clazz);
        return cacheItem != null && cacheItem.isLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Code> List<T> getCodes(Class<T> clazz) {
        Class<T> clazz2 = clazz;
        synchronized (clazz2) {
            Codes.CodeCacheItem<? extends Code> cacheItem = this.codeCache.get(clazz);
            if (cacheItem == null || !cacheItem.isValid()) {
                this.updateCode(clazz);
            }
            cacheItem = this.codeCache.get(clazz);
            List<? extends Code> codes = cacheItem.getCodes();
            return codes;
        }
    }

    private <T extends Code> void updateCode(Class<T> clazz) {
        Codes.CodeCacheItem<T> codeCacheItem = new Codes.CodeCacheItem<T>();
        this.codeCache.put(clazz, codeCacheItem);
        List<T> codes = this.find(clazz, By.all());
        codeCacheItem.setCodes(codes);
    }

    public void invalidateCodeCache(Class<?> clazz) {
        this.codeCache.remove(clazz);
    }

    public int getMaxIdentifierLength() {
        return this.sqlDialect.getMaxIdentifierLength();
    }

    public Map<String, AbstractTable<?>> getTableByName() {
        return this.tableByName;
    }

    private static class SqlQueryResultList<T>
    extends QueryResultList<T> {
        private static final long serialVersionUID = 1L;

        public SqlQueryResultList(Repository repository, Class<T> clazz, Query.QueryLimitable query) {
            super(repository, clazz, query);
        }

        @Override
        public boolean canSortBy(Object sortKey) {
            PropertyInterface property = Keys.getProperty(sortKey);
            if (property.getClass() != FieldProperty.class) {
                return false;
            }
            return property.getClazz() == String.class || Number.class.isAssignableFrom(property.getClazz()) || Temporal.class.isAssignableFrom(property.getClazz());
        }
    }
}

