/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.sql.AbstractTable;
import org.minimalj.repository.sql.HistorizedSubTable;
import org.minimalj.repository.sql.SqlDialect;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.repository.sql.SubTable;
import org.minimalj.repository.sql.Table;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LoggingRuntimeException;

public class HistorizedTable<T>
extends Table<T> {
    private final String selectByIdAndTimeQuery = this.selectByIdAndTimeQuery();
    private final String endQuery = this.endQuery();
    private final String selectMaxVersionQuery = this.selectMaxVersionQuery();

    public HistorizedTable(SqlRepository sqlRepository, Class<T> clazz) {
        super(sqlRepository, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object insert(T object) {
        try (PreparedStatement insertStatement = HistorizedTable.createStatement(this.sqlRepository.getConnection(), this.insertQuery, true);){
            Object id = IdUtils.getId(object);
            if (id == null) {
                id = IdUtils.createId();
                IdUtils.setId(object, id);
            }
            this.setParameters(insertStatement, object, false, AbstractTable.ParameterMode.INSERT, id);
            insertStatement.execute();
            this.insertLists(object);
            Object object2 = id;
            return object2;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't insert object into " + this.getTableName() + " / Object: " + object + " ex: " + x);
        }
    }

    @Override
    SubTable createListTable(PropertyInterface property) {
        Class<?> elementClass = GenericUtils.getGenericClass(property.getType());
        if (IdUtils.hasId(elementClass)) {
            throw new RuntimeException("Not yet implemented");
        }
        return new HistorizedSubTable(this.sqlRepository, this.buildSubTableName(property), elementClass, this.idProperty);
    }

    @Override
    public void update(T object) {
        Object id = IdUtils.getId(object);
        this.update(id, object);
    }

    private void update(Object id, T object) {
        try {
            int version = IdUtils.getVersion(object);
            PreparedStatement endStatement = HistorizedTable.createStatement(this.sqlRepository.getConnection(), this.endQuery, false);
            Object object2 = null;
            try {
                endStatement.setObject(1, id);
                endStatement.setInt(2, version);
                endStatement.execute();
                if (endStatement.getUpdateCount() == 0) {
                    throw new IllegalStateException("Optimistic locking failed");
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (endStatement != null) {
                    if (object2 != null) {
                        try {
                            endStatement.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        endStatement.close();
                    }
                }
            }
            int newVersion = version + 1;
            Throwable throwable = null;
            try (PreparedStatement updateStatement = HistorizedTable.createStatement(this.sqlRepository.getConnection(), this.updateQuery, false);){
                int parameterIndex = this.setParameters(updateStatement, object, false, AbstractTable.ParameterMode.HISTORIZE, id);
                updateStatement.setInt(parameterIndex, newVersion);
                updateStatement.execute();
            }
            catch (Throwable parameterIndex) {
                Throwable throwable2 = parameterIndex;
                throw parameterIndex;
            }
            for (Map.Entry entry : this.lists.entrySet()) {
                List list = (List)((PropertyInterface)entry.getKey()).getValue(object);
                ((HistorizedSubTable)entry.getValue()).replaceAll(object, list, newVersion);
            }
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't update in " + this.getTableName() + " with " + object);
        }
    }

    /*
     * Exception decompiling
     */
    public int getMaxVersion(Object id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(Object id) {
        try (PreparedStatement selectByIdStatement = HistorizedTable.createStatement(this.sqlRepository.getConnection(), this.selectByIdQuery, false);){
            selectByIdStatement.setObject(1, id);
            Object object = this.executeSelect(selectByIdStatement);
            if (object != null) {
                this.loadLists(object, null);
            }
            Object t = object;
            return t;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't read " + this.getTableName() + " with ID " + id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(Object id, Integer time) {
        if (time == null) return this.read(id);
        try (PreparedStatement selectByIdAndTimeStatement = HistorizedTable.createStatement(this.sqlRepository.getConnection(), this.selectByIdAndTimeQuery, false);){
            selectByIdAndTimeStatement.setObject(1, id);
            selectByIdAndTimeStatement.setInt(2, time);
            Object object = this.executeSelect(selectByIdAndTimeStatement);
            this.loadLists(object, time);
            Object t = object;
            return t;
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't read " + this.getTableName() + " with ID " + id + " on time " + time);
        }
    }

    @Override
    public void delete(Object id) {
        try (PreparedStatement deleteStatement = HistorizedTable.createStatement(this.sqlRepository.getConnection(), this.deleteQuery, false);){
            deleteStatement.setObject(1, id);
            deleteStatement.execute();
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Couldn't update in " + this.getTableName() + " with id " + id);
        }
    }

    @Override
    protected void loadLists(T object) {
        this.loadLists(object, null);
    }

    private void loadLists(T object, Integer time) {
        for (Map.Entry listTableEntry : this.lists.entrySet()) {
            List values = ((HistorizedSubTable)listTableEntry.getValue()).read(object, time);
            PropertyInterface listProperty = (PropertyInterface)listTableEntry.getKey();
            if (listProperty.isFinal()) {
                List list = (List)listProperty.getValue(object);
                list.clear();
                list.addAll(values);
                continue;
            }
            listProperty.setValue(object, values);
        }
    }

    @Override
    protected String selectByIdQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName());
        query.append(" WHERE id = ? AND historized = 0");
        return query.toString();
    }

    @Override
    protected String selectAllQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName());
        query.append(" WHERE historized = 0");
        return query.toString();
    }

    protected String selectByIdAndTimeQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName());
        query.append(" WHERE id = ? AND version = ?");
        return query.toString();
    }

    @Override
    protected String insertQuery() {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ").append(this.getTableName()).append(" (");
        for (String columnName : this.getColumns().keySet()) {
            s.append(columnName).append(", ");
        }
        s.append("id, version, historized) VALUES (");
        for (int i = 0; i < this.getColumns().size(); ++i) {
            s.append("?, ");
        }
        s.append("?, 0, 0)");
        return s.toString();
    }

    @Override
    protected String updateQuery() {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ").append(this.getTableName()).append(" (");
        for (String name : this.getColumns().keySet()) {
            s.append(name);
            s.append(", ");
        }
        s.append("id, version, historized) VALUES (");
        for (int i = 0; i < this.getColumns().size(); ++i) {
            s.append("?, ");
        }
        s.append("?, ?, 0)");
        return s.toString();
    }

    private String selectMaxVersionQuery() {
        StringBuilder s = new StringBuilder();
        s.append("SELECT MAX(version) FROM ").append(this.getTableName());
        s.append(" WHERE id = ?");
        return s.toString();
    }

    private String endQuery() {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE ").append(this.getTableName()).append(" SET historized = 1 WHERE id = ? AND version = ? AND historized = 0");
        return s.toString();
    }

    @Override
    protected String deleteQuery() {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE ").append(this.getTableName()).append(" SET historized = 1 WHERE id = ? AND historized = 0");
        return s.toString();
    }

    @Override
    protected void addSpecialColumns(SqlDialect dialect, StringBuilder s) {
        super.addSpecialColumns(dialect, s);
        s.append(",\n historized INTEGER NOT NULL");
    }

    @Override
    protected void addPrimaryKey(SqlDialect dialect, StringBuilder s) {
        dialect.addPrimaryKey(s, "id, version");
    }
}

