/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.model.Code;
import org.minimalj.model.Keys;
import org.minimalj.model.View;
import org.minimalj.model.ViewUtil;
import org.minimalj.model.annotation.NotEmpty;
import org.minimalj.model.annotation.TechnicalField;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.query.FieldOperator;
import org.minimalj.repository.sql.HistorizedTable;
import org.minimalj.repository.sql.LoggingPreparedStatement;
import org.minimalj.repository.sql.SqlDialect;
import org.minimalj.repository.sql.SqlIdentifier;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.repository.sql.Table;
import org.minimalj.security.Subject;
import org.minimalj.util.EqualsHelper;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LoggingRuntimeException;
import org.minimalj.util.StringUtils;

public abstract class AbstractTable<T> {
    public static final Logger sqlLogger = Logger.getLogger("SQL");
    protected final SqlRepository sqlRepository;
    protected final Class<T> clazz;
    protected final LinkedHashMap<String, PropertyInterface> columns;
    protected final String name;
    protected final List<String> indexes = new ArrayList<String>();
    protected final String selectByIdQuery;
    protected final String insertQuery;
    protected final String updateQuery;
    protected final String deleteQuery;
    protected final String clearQuery;

    protected AbstractTable(SqlRepository sqlRepository, String name, Class<T> clazz) {
        this.sqlRepository = sqlRepository;
        this.name = this.buildTableName(sqlRepository, name != null ? name : StringUtils.toSnakeCase(clazz.getSimpleName()));
        this.clazz = clazz;
        this.columns = sqlRepository.findColumns(clazz);
        sqlRepository.getTableByName().put(this.name, this);
        this.selectByIdQuery = this.selectByIdQuery();
        this.insertQuery = this.insertQuery();
        this.updateQuery = this.updateQuery();
        this.deleteQuery = this.deleteQuery();
        this.clearQuery = this.clearQuery();
        this.findCodes();
        this.findDependables();
        this.findIndexes();
    }

    public String buildTableName(SqlRepository repository, String name) {
        name = SqlIdentifier.buildIdentifier(name, repository.getMaxIdentifierLength(), repository.getTableByName().keySet());
        repository.getTableByName().put(name, this);
        return name;
    }

    protected LinkedHashMap<String, PropertyInterface> getColumns() {
        return this.columns;
    }

    protected Collection<String> getIndexes() {
        return this.indexes;
    }

    static PreparedStatement createStatement(Connection connection, String query, boolean returnGeneratedKeys) throws SQLException {
        int autoGeneratedKeys;
        int n = autoGeneratedKeys = returnGeneratedKeys ? 1 : 2;
        if (sqlLogger.isLoggable(Level.FINE)) {
            return new LoggingPreparedStatement(connection, query, autoGeneratedKeys, sqlLogger);
        }
        return connection.prepareStatement(query, autoGeneratedKeys);
    }

    protected void execute(String s) {
        try (PreparedStatement statement = AbstractTable.createStatement(this.sqlRepository.getConnection(), s.toString(), false);){
            statement.execute();
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Statement failed: \n" + s.toString());
        }
    }

    protected void createTable(SqlDialect dialect) {
        StringBuilder s = new StringBuilder();
        dialect.addCreateStatementBegin(s, this.getTableName());
        this.addSpecialColumns(dialect, s);
        this.addFieldColumns(dialect, s);
        this.addPrimaryKey(dialect, s);
        dialect.addCreateStatementEnd(s);
        this.execute(s.toString());
    }

    protected abstract void addSpecialColumns(SqlDialect var1, StringBuilder var2);

    protected void addFieldColumns(SqlDialect dialect, StringBuilder s) {
        for (Map.Entry<String, PropertyInterface> column : this.getColumns().entrySet()) {
            s.append(",\n ").append(column.getKey()).append(' ');
            PropertyInterface property = column.getValue();
            dialect.addColumnDefinition(s, property);
            boolean isNotEmpty = property.getAnnotation(NotEmpty.class) != null;
            s.append(isNotEmpty ? " NOT NULL" : " DEFAULT NULL");
        }
    }

    protected void addPrimaryKey(SqlDialect dialect, StringBuilder s) {
        dialect.addPrimaryKey(s, "ID");
    }

    protected void createIndexes(SqlDialect dialect) {
        for (String index : this.indexes) {
            String s = dialect.createIndex(this.getTableName(), index, this instanceof HistorizedTable);
            this.execute(s.toString());
        }
    }

    protected void createConstraints(SqlDialect dialect) {
        for (Map.Entry<String, PropertyInterface> column : this.getColumns().entrySet()) {
            PropertyInterface property = column.getValue();
            if (!IdUtils.hasId(property.getClazz())) continue;
            Class<?> fieldClass = property.getClazz();
            fieldClass = ViewUtil.resolve(fieldClass);
            AbstractTable<?> referencedTable = this.sqlRepository.getAbstractTable(fieldClass);
            String s = dialect.createConstraint(this.getTableName(), column.getKey(), referencedTable.getTableName(), referencedTable instanceof HistorizedTable);
            if (s == null) continue;
            this.execute(s.toString());
        }
    }

    public void clear() {
        try (PreparedStatement statement = AbstractTable.createStatement(this.sqlRepository.getConnection(), this.clearQuery, false);){
            statement.execute();
        }
        catch (SQLException x) {
            throw new LoggingRuntimeException(x, sqlLogger, "Clear of Table " + this.getTableName() + " failed");
        }
    }

    protected String findColumn(String fieldPath) {
        for (Map.Entry<String, PropertyInterface> entry : this.columns.entrySet()) {
            if (!entry.getValue().getPath().equals(fieldPath)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String column(PropertyInterface property) {
        return this.findColumn(property.getPath());
    }

    public String column(Object key) {
        return this.column(Keys.getProperty(key));
    }

    protected String getTableName() {
        return this.name;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    private void findCodes() {
        for (Map.Entry<String, PropertyInterface> column : this.getColumns().entrySet()) {
            PropertyInterface property = column.getValue();
            Class<?> fieldClazz = property.getClazz();
            if (!Code.class.isAssignableFrom(fieldClazz) || fieldClazz == this.clazz) continue;
            this.sqlRepository.addClass(fieldClazz);
        }
    }

    private void findDependables() {
        for (Map.Entry<String, PropertyInterface> column : this.getColumns().entrySet()) {
            PropertyInterface property = column.getValue();
            Class<?> fieldClazz = property.getClazz();
            if (!AbstractTable.isDependable(property) || fieldClazz == this.clazz || View.class.isAssignableFrom(property.getClazz())) continue;
            this.sqlRepository.addClass(fieldClazz);
        }
        for (PropertyInterface property : FlatProperties.getListProperties(this.getClazz())) {
            Class<?> listType = GenericUtils.getGenericClass(property.getType());
            if (!IdUtils.hasId(listType) || View.class.isAssignableFrom(listType)) continue;
            this.sqlRepository.addClass(listType);
        }
    }

    protected void findIndexes() {
        for (Map.Entry<String, PropertyInterface> column : this.columns.entrySet()) {
            PropertyInterface property = column.getValue();
            if (!IdUtils.hasId(property.getClazz())) continue;
            this.createIndex(property, property.getPath());
        }
    }

    protected String whereStatement(String wholeFieldPath, FieldOperator criteriaOperator) {
        String column;
        String fieldPath = wholeFieldPath;
        while ((column = this.findColumn(fieldPath)) == null) {
            int pos = fieldPath.lastIndexOf(46);
            if (pos < 0) {
                throw new IllegalArgumentException("FieldPath " + wholeFieldPath + " not even partially found in " + this.getTableName());
            }
            fieldPath = fieldPath.substring(0, pos);
        }
        if (fieldPath.length() < wholeFieldPath.length()) {
            String restOfFieldPath = wholeFieldPath.substring(fieldPath.length() + 1);
            if ("id".equals(restOfFieldPath)) {
                return column + " " + criteriaOperator.getOperatorAsString() + " ?";
            }
            PropertyInterface subProperty = this.columns.get(column);
            AbstractTable<?> subTable = this.sqlRepository.getAbstractTable(subProperty.getClazz());
            return column + " = (select ID from " + subTable.getTableName() + " where " + subTable.whereStatement(restOfFieldPath, criteriaOperator) + ")";
        }
        return column + " " + criteriaOperator.getOperatorAsString() + " ?";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executeSelectCount(PreparedStatement preparedStatement) {
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            long l = resultSet.getLong(1);
            return l;
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T executeSelect(PreparedStatement preparedStatement) {
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                T t = this.sqlRepository.readResultSetRow(this.clazz, resultSet);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T executeSelect(PreparedStatement preparedStatement, Map<Class<?>, Map<Object, Object>> loadedReferences) {
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                T t = this.sqlRepository.readResultSetRow(this.clazz, resultSet, loadedReferences);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    protected List<T> executeSelectAll(PreparedStatement preparedStatement) {
        ArrayList<T> result = new ArrayList<T>();
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            HashMap loadedReferences = new HashMap();
            while (resultSet.next()) {
                T object = this.sqlRepository.readResultSetRow(this.clazz, resultSet, loadedReferences);
                if (this instanceof Table) {
                    ((Table)this).loadLists(object);
                }
                result.add(object);
            }
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
        return result;
    }

    protected int setParameters(PreparedStatement statement, T object, boolean doubleValues, ParameterMode mode, Object id) throws SQLException {
        int parameterPos = 1;
        for (Map.Entry<String, PropertyInterface> column : this.columns.entrySet()) {
            PropertyInterface property = column.getValue();
            Object value = property.getValue(object);
            if (value instanceof Code) {
                value = this.findId((Code)value);
            } else if (IdUtils.hasId(property.getClazz())) {
                if (value != null) {
                    Object referencedId = IdUtils.getId(value);
                    if (referencedId != null) {
                        value = referencedId;
                    } else {
                        Table<?> referencedTable = this.sqlRepository.getTable(property.getClazz());
                        value = referencedTable.insert(value);
                    }
                }
            } else if (AbstractTable.isDependable(property)) {
                Table<?> dependableTable = this.sqlRepository.getTable(property.getClazz());
                if (mode == ParameterMode.INSERT) {
                    if (value != null) {
                        value = dependableTable.insert(value);
                    }
                } else {
                    String dependableColumnName = column.getKey();
                    Object dependableId = this.getDependableId(id, dependableColumnName);
                    if (value != null) {
                        value = this.updateDependable(dependableTable, dependableId, value, mode);
                    } else if (mode == ParameterMode.UPDATE) {
                        this.setColumnToNull(id, dependableColumnName);
                        dependableTable.delete(dependableId);
                    }
                }
            } else {
                TechnicalField technicalField = property.getAnnotation(TechnicalField.class);
                if (technicalField != null) {
                    Subject subject;
                    TechnicalField.TechnicalFieldType type = technicalField.value();
                    if (type == TechnicalField.TechnicalFieldType.EDIT_DATE || type == TechnicalField.TechnicalFieldType.CREATE_DATE && mode == ParameterMode.INSERT) {
                        value = LocalDateTime.now();
                    } else if ((type == TechnicalField.TechnicalFieldType.EDIT_USER || type == TechnicalField.TechnicalFieldType.CREATE_USER && mode == ParameterMode.INSERT) && (subject = Subject.getCurrent()) != null) {
                        value = subject.getName();
                    }
                }
            }
            this.sqlRepository.getSqlDialect().setParameter(statement, parameterPos++, value, property);
            if (!doubleValues) continue;
            this.sqlRepository.getSqlDialect().setParameter(statement, parameterPos++, value, property);
        }
        statement.setObject(parameterPos++, id);
        if (doubleValues) {
            statement.setObject(parameterPos++, id);
        }
        return parameterPos;
    }

    protected Object updateDependable(Table dependableTable, Object dependableId, Object dependableObject, ParameterMode mode) {
        if (dependableId != null) {
            Object objectInDb = dependableTable.read(dependableId);
            if (!EqualsHelper.equals(dependableObject, objectInDb)) {
                if (mode == ParameterMode.HISTORIZE) {
                    IdUtils.setId(dependableObject, null);
                    dependableId = dependableTable.insert(dependableObject);
                } else {
                    dependableTable.updateWithId(dependableObject, dependableId);
                }
            }
        } else {
            dependableId = dependableTable.insert(dependableObject);
        }
        return dependableId;
    }

    /*
     * Exception decompiling
     */
    private Object getDependableId(Object id, String column) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setColumnToNull(Object id, String column) {
        String update = "UPDATE " + this.getTableName() + " SET " + column + " = NULL WHERE ID = ?";
        try (PreparedStatement preparedStatement = AbstractTable.createStatement(this.sqlRepository.getConnection(), update, false);){
            preparedStatement.setObject(1, id);
            preparedStatement.execute();
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    private Object findId(Code code) {
        Object id = IdUtils.getId(code);
        if (id != null) {
            return id;
        }
        List<?> codes = this.sqlRepository.getCodes(code.getClass());
        for (Object c : codes) {
            if (!code.equals(c)) continue;
            return IdUtils.getId(c);
        }
        return null;
    }

    protected abstract String insertQuery();

    protected abstract String updateQuery();

    protected abstract String deleteQuery();

    protected abstract String selectByIdQuery();

    protected String clearQuery() {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ").append(this.getTableName());
        return query.toString();
    }

    protected final Object getOrCreateId(Object object) {
        Object id = IdUtils.getId(object);
        if (id == null) {
            id = this.sqlRepository.insert(object);
        }
        return id;
    }

    public void createIndex(Object key) {
        PropertyInterface property = Keys.getProperty(key);
        String fieldPath = property.getPath();
        this.createIndex(property, fieldPath);
    }

    public void createIndex(PropertyInterface property, String fieldPath) {
        Map.Entry<String, PropertyInterface> entry = this.findX(fieldPath);
        if (this.indexes.contains(entry.getKey())) {
            return;
        }
        String myFieldPath = entry.getValue().getPath();
        if (fieldPath.length() > myFieldPath.length()) {
            String rest = fieldPath.substring(myFieldPath.length() + 1);
            AbstractTable<?> innerTable = this.sqlRepository.getAbstractTable(entry.getValue().getClazz());
            innerTable.createIndex(property, rest);
        }
        this.indexes.add(entry.getKey());
    }

    protected Map.Entry<String, PropertyInterface> findX(String fieldPath) {
        while (true) {
            for (Map.Entry<String, PropertyInterface> entry : this.columns.entrySet()) {
                String columnFieldPath = entry.getValue().getPath();
                if (!columnFieldPath.equals(fieldPath)) continue;
                return entry;
            }
            int index = fieldPath.lastIndexOf(46);
            if (index < 0) {
                throw new IllegalArgumentException();
            }
            fieldPath = fieldPath.substring(0, index);
        }
    }

    public static boolean isDependable(PropertyInterface property) {
        if (property.getClazz().getName().startsWith("java")) {
            return false;
        }
        if (Enum.class.isAssignableFrom(property.getClazz())) {
            return false;
        }
        if (property.isFinal()) {
            return false;
        }
        return !property.getClazz().isArray();
    }

    protected static enum ParameterMode {
        INSERT,
        UPDATE,
        HISTORIZE;

    }
}

