/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.query;

import java.io.Serializable;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.query.Limit;
import org.minimalj.repository.query.Order;

public interface Query
extends Serializable {

    public static interface QueryOrderable
    extends QueryLimitable {
        default public Order order(Object key) {
            return this.order(key, true);
        }

        default public Order order(Object key, boolean ascending) {
            PropertyInterface property = Keys.getProperty(key);
            String path = property.getPath();
            return new Order(this, path, ascending);
        }
    }

    public static interface QueryLimitable
    extends Query {
        default public Query limit(int rows) {
            return new Limit(this, rows);
        }

        default public Query limit(Integer offset, int rows) {
            return new Limit(this, offset, rows);
        }
    }
}

