/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.list;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.minimalj.repository.Repository;
import org.minimalj.repository.list.QueryResultList;
import org.minimalj.repository.list.RelationCriteria;
import org.minimalj.util.IdUtils;

public class RelationList<PARENT, ELEMENT>
extends AbstractList<ELEMENT>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient List<ELEMENT> list;
    private int size;

    public RelationList(Repository repository, Class<ELEMENT> elementClass, PARENT parent, String crossName) {
        Object parentId = IdUtils.getId(parent);
        this.list = repository.find(elementClass, new RelationCriteria(crossName, parentId));
        this.size = this.list.size();
    }

    public boolean isLoaded() {
        return this.list != null;
    }

    private void loadComplete() {
        if (this.list instanceof QueryResultList) {
            QueryResultList queryResultList = (QueryResultList)this.list;
            this.list = new ArrayList(queryResultList.subList(0, this.size));
        }
    }

    @Override
    public ELEMENT get(int index) {
        return this.list.get(index);
    }

    @Override
    public List<ELEMENT> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        if (this.list instanceof QueryResultList) {
            return this.size;
        }
        return this.list.size();
    }

    @Override
    public ELEMENT set(int index, ELEMENT element) {
        this.loadComplete();
        return super.set(index, element);
    }

    @Override
    public void add(int index, ELEMENT element) {
        this.loadComplete();
        this.list.add(index, element);
    }

    @Override
    public ELEMENT remove(int index) {
        this.loadComplete();
        return this.list.remove(index);
    }
}

