/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.list;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import org.minimalj.backend.Backend;
import org.minimalj.backend.repository.ReadCriteriaTransaction;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.Repository;
import org.minimalj.repository.query.Order;
import org.minimalj.repository.query.Query;
import org.minimalj.util.ClassHolder;
import org.minimalj.util.Sortable;

public class QueryResultList<T>
extends AbstractList<T>
implements Sortable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Repository repository;
    private final ClassHolder<T> clazz;
    private Query.QueryLimitable query;
    private final int size;

    public QueryResultList(Repository repository, Class<T> clazz, Query.QueryLimitable query) {
        this.repository = repository;
        this.clazz = new ClassHolder<T>(clazz);
        this.query = query;
        this.size = (int)repository.count(clazz, query);
    }

    @Override
    public T get(int index) {
        Query limtedCriteria = this.query.limit(index, 1);
        List<T> result = this.find(limtedCriteria);
        return result.isEmpty() ? null : (T)result.get(0);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Query limtedCriteria = this.query.limit(fromIndex, toIndex - fromIndex);
        return this.find(limtedCriteria);
    }

    private List<T> find(Query limtedCriteria) {
        return this.repository != null ? this.repository.find(this.clazz.getClazz(), limtedCriteria) : (List)Backend.execute(new ReadCriteriaTransaction<T>(this.clazz.getClazz(), limtedCriteria));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void sort(Object[] sortKeys, boolean[] sortDirections) {
        while (this.query instanceof Order) {
            this.query = ((Order)this.query).getQuery();
        }
        for (int i = 0; i < sortKeys.length; ++i) {
            PropertyInterface property = Keys.getProperty(sortKeys[i]);
            this.query = ((Query.QueryOrderable)this.query).order(property, sortDirections[i]);
        }
    }

    @Override
    public boolean canSortBy(Object sortKey) {
        return true;
    }
}

