/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.minimalj.application.Application;
import org.minimalj.application.Configuration;
import org.minimalj.repository.DataSourceFactory;
import org.minimalj.repository.query.Query;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.util.StringUtils;

public interface Repository {
    public static final Logger logger = Logger.getLogger(Repository.class.getName());

    public static Repository create() {
        Class<?>[] entityClasses = Application.getInstance().getEntityClasses();
        if (Configuration.available("MjRepository")) {
            return Configuration.getClazz("MjRepository", Repository.class, new Object[]{entityClasses});
        }
        DataSource jndiDataSource = DataSourceFactory.getJndiDataSource();
        if (jndiDataSource != null) {
            return new SqlRepository(jndiDataSource, entityClasses);
        }
        String database = Configuration.get("MjSqlDatabase");
        String user = Configuration.get("MjSqlDatabaseUser", "APP");
        String password = Configuration.get("MjSqlDatabasePassword", "APP");
        if (!StringUtils.isBlank(database)) {
            return new SqlRepository(DataSourceFactory.dataSource(database, user, password), entityClasses);
        }
        String databaseFile = Configuration.get("MjSqlDatabaseFile", null);
        boolean createTables = databaseFile == null || !new File(databaseFile).exists();
        return new SqlRepository(DataSourceFactory.embeddedDataSource(databaseFile), createTables, entityClasses);
    }

    public <T> T read(Class<T> var1, Object var2);

    public <T> List<T> find(Class<T> var1, Query var2);

    public <T> long count(Class<T> var1, Query var2);

    public <T> Object insert(T var1);

    public <T> void update(T var1);

    public <T> void delete(Class<T> var1, Object var2);
}

