/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model.validation;

import java.util.ArrayList;
import java.util.List;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;

public class ValidationMessage {
    private String formattedText;
    private Object key;

    public ValidationMessage(Object key, String formattedText) {
        this.key = key;
        this.formattedText = formattedText;
    }

    public String getFormattedText() {
        return this.formattedText;
    }

    public Object getKey() {
        return this.key;
    }

    public PropertyInterface getProperty() {
        if (this.key instanceof PropertyInterface) {
            return (PropertyInterface)this.key;
        }
        return Keys.getProperty(this.key);
    }

    public String toString() {
        return "ValidationMessage [key=" + this.key + ", formattedText=" + this.formattedText + "]";
    }

    public static List<String> filterValidationMessage(List<ValidationMessage> validationMessages, PropertyInterface property) {
        ArrayList<String> filteredMessages = new ArrayList<String>();
        if (validationMessages != null) {
            for (ValidationMessage validationMessage : validationMessages) {
                if (!validationMessage.getProperty().equals(property)) continue;
                filteredMessages.add(validationMessage.getFormattedText());
            }
        }
        return filteredMessages;
    }

    public static String formatHtml(List<ValidationMessage> validationMessages) {
        if (validationMessages != null && validationMessages.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append("<html>");
            for (int i = 0; i < validationMessages.size(); ++i) {
                s.append(validationMessages.get((int)i).formattedText);
                if (i >= validationMessages.size() - 1) continue;
                s.append("<br>");
            }
            s.append("</html>");
            return s.toString();
        }
        return null;
    }
}

