/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.logging.Logger;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.Decimal;
import org.minimalj.model.annotation.Signed;
import org.minimalj.model.annotation.Size;
import org.minimalj.model.annotation.Sizes;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.FieldUtils;

public class AnnotationUtil {
    private static final Logger logger = Logger.getLogger(AnnotationUtil.class.getName());
    public static final boolean OPTIONAL = true;

    public static int getSize(PropertyInterface property) {
        return AnnotationUtil.getSize(property, false);
    }

    public static int getSize(PropertyInterface property, boolean optional) {
        Size size = property.getAnnotation(Size.class);
        if (size != null) {
            return size.value();
        }
        Sizes sizes = property.getDeclaringClass().getAnnotation(Sizes.class);
        if (sizes != null) {
            Class<?> sizeClass = sizes.value();
            for (Field field : sizeClass.getFields()) {
                if (field.getType() != Integer.TYPE || !FieldUtils.isStatic(field) || !field.getName().equals(property.getName())) continue;
                try {
                    return field.getInt(null);
                }
                catch (Exception x) {
                    throw new RuntimeException(x);
                }
            }
        }
        if (property.getClazz() == BigDecimal.class) {
            return 10;
        }
        if (property.getClazz() == Integer.class) {
            return Size.INTEGER;
        }
        if (property.getClazz() == Long.class) {
            return Size.LONG;
        }
        if (optional) {
            return -1;
        }
        logger.fine("You must annotate the fields with a @size or the entire class with @sizes");
        throw new IllegalArgumentException("Size not specified for " + property.getName() + " on " + property.getDeclaringClass());
    }

    public static int getDecimal(PropertyInterface property) {
        Decimal decimal = property.getAnnotation(Decimal.class);
        if (decimal != null) {
            return decimal.value();
        }
        return 0;
    }

    public static <T extends Annotation> T get(Class<T> annotationClass, Class<?> clazz, Object key) {
        PropertyInterface property = Keys.getProperty(key);
        return property.getAnnotation(annotationClass);
    }

    public static boolean isSigned(PropertyInterface property) {
        return property.getAnnotation(Signed.class) != null;
    }
}

