/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.properties.ChainedProperty;
import org.minimalj.model.properties.Properties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.StringUtils;

public class Keys {
    private static final Logger logger = Logger.getLogger(Keys.class.getName());
    private static final Map<Object, PropertyInterface> properties = new IdentityHashMap<Object, PropertyInterface>();
    private static final Map<PropertyInterface, List<PropertyInterface>> dependencies = new HashMap<PropertyInterface, List<PropertyInterface>>();
    private static final List<Object> keyObjects = new ArrayList<Object>();
    private static final Map<String, Object> methodKeyByName = new HashMap<String, Object>();

    public static <T> T of(Class<T> clazz) {
        try {
            T object = clazz.newInstance();
            keyObjects.add(object);
            Keys.fillFields(object, null, 0);
            return object;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isKeyObject(Object object) {
        return keyObjects.contains(object) || properties.containsKey(object);
    }

    public static <T> T methodOf(Object keyObject, String propertyName, Object ... dependencies) {
        String qualifiedMethodName = null;
        PropertyInterface enclosingProperty = null;
        if (properties.containsKey(keyObject)) {
            enclosingProperty = properties.get(keyObject);
            qualifiedMethodName = enclosingProperty.getDeclaringClass().getName() + "." + enclosingProperty.getPath() + "." + propertyName;
        } else {
            qualifiedMethodName = keyObject.getClass().getName() + "." + propertyName;
        }
        PropertyInterface property = Keys.getMethodProperty(keyObject.getClass(), propertyName);
        if (property == null) {
            if (propertyName.startsWith("get")) {
                throw new IllegalArgumentException("methodOf must be called with the property name. Not with the getter name");
            }
            throw new IllegalArgumentException("methodOf called with invalid property name");
        }
        if (enclosingProperty != null) {
            property = new ChainedProperty(enclosingProperty, property);
        }
        if (methodKeyByName.containsKey(qualifiedMethodName)) {
            return (T)methodKeyByName.get(qualifiedMethodName);
        }
        Object t = Keys.createKey(property.getClazz(), qualifiedMethodName, null);
        methodKeyByName.put(qualifiedMethodName, t);
        Keys.fillFields(t, property, 0);
        properties.put(t, property);
        ArrayList<PropertyInterface> dependenciesList = new ArrayList<PropertyInterface>();
        if (dependencies != null && dependencies.length > 0) {
            for (Object d : dependencies) {
                PropertyInterface dependency = Keys.getProperty(d);
                if (enclosingProperty != null) {
                    dependency = new ChainedProperty(enclosingProperty, dependency);
                }
                dependenciesList.add(dependency);
            }
        }
        if (enclosingProperty != null) {
            dependenciesList.add(enclosingProperty);
            List<PropertyInterface> enclosingDependencies = Keys.dependencies.get(enclosingProperty);
            if (enclosingDependencies != null) {
                dependenciesList.addAll(enclosingDependencies);
            }
        }
        if (!dependenciesList.isEmpty()) {
            Keys.dependencies.put(property, dependenciesList);
        }
        return (T)t;
    }

    private static <T> void fillFields(T object, PropertyInterface enclosingProperty, int depth) {
        Map<String, PropertyInterface> propertiesOfObject = Properties.getProperties(object.getClass());
        for (PropertyInterface property : propertiesOfObject.values()) {
            boolean fill;
            Object value = null;
            Class<?> clazz = property.getClazz();
            if (property.isFinal()) {
                value = property.getValue(object);
            } else {
                value = Keys.createKey(clazz, property.getName(), property.getDeclaringClass());
                property.setValue(object, value);
            }
            if (enclosingProperty != null) {
                property = new ChainedProperty(enclosingProperty, property);
            }
            boolean bl = fill = !clazz.getName().startsWith("java") && !clazz.isArray();
            if (fill && depth < 6) {
                Keys.fillFields(value, property, depth + 1);
            }
            properties.put(value, property);
        }
    }

    private static Object createKey(Class<?> clazz, String fieldName, Class<?> declaringClass) {
        if (clazz == String.class) {
            return new String(fieldName);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new Integer(0);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return new Long(0L);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            Class<?> enumClass = clazz;
            return EnumUtils.createEnum(enumClass, fieldName);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new Boolean(false);
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(0);
        }
        if (clazz == LocalDate.class) {
            return LocalDate.now();
        }
        if (clazz == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        if (clazz == LocalTime.class) {
            return LocalTime.now();
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }
        if (clazz == List.class) {
            return new ArrayList();
        }
        try {
            Object keyObject = clazz.newInstance();
            keyObjects.add(keyObject);
            return keyObject;
        }
        catch (Exception x) {
            if (declaringClass != null) {
                logger.severe("Could not instantiat " + fieldName + " in class " + declaringClass);
            } else {
                logger.severe("Could not instantiat " + fieldName);
            }
            return null;
        }
    }

    public static PropertyInterface getProperty(Object key) {
        if (key instanceof PropertyInterface) {
            return (PropertyInterface)key;
        }
        return properties.get(key);
    }

    public static PropertyInterface[] getProperties(Object[] keys) {
        PropertyInterface[] properties = new PropertyInterface[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            properties[i] = Keys.getProperty(keys[i]);
        }
        return properties;
    }

    public static List<PropertyInterface> getDependencies(PropertyInterface property) {
        if (dependencies.containsKey(property)) {
            return dependencies.get(property);
        }
        return Collections.emptyList();
    }

    private static MethodProperty getMethodProperty(Class<?> clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String name;
            if (Keys.isStatic(method) || !Keys.isPublic(method) || method.getDeclaringClass() != clazz || !(name = method.getName()).startsWith("get") && name.length() > 3 || !StringUtils.lowerFirstChar(name.substring(3)).equals(methodName)) continue;
            String setterName = "set" + name.substring(3);
            Method setterMethod = null;
            for (Method m : methods) {
                if (!m.getName().equals(setterName)) continue;
                setterMethod = m;
                break;
            }
            return new MethodProperty(clazz, methodName, method, setterMethod);
        }
        return null;
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static class MethodProperty
    implements PropertyInterface {
        private final Class<?> clazz;
        private final Method getterMethod;
        private final Method setterMethod;
        private final String name;

        public MethodProperty(Class<?> clazz, String key, Method getterMethod, Method setterMethod) {
            if (getterMethod == null) {
                throw new IllegalArgumentException();
            }
            this.clazz = clazz;
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
            this.name = key;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.clazz;
        }

        @Override
        public Object getValue(Object object) {
            try {
                return this.getterMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setValue(Object object, Object value) {
            if (this.setterMethod == null) {
                logger.severe("No setter method for " + this.getterMethod.getName() + " on " + this.getterMethod.getDeclaringClass().getName());
                return;
            }
            try {
                this.setterMethod.invoke(object, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.getName();
        }

        @Override
        public Type getType() {
            return this.getterMethod.getGenericReturnType();
        }

        @Override
        public Class<?> getClazz() {
            return this.getterMethod.getReturnType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.getterMethod.getAnnotation(annotationClass);
        }

        @Override
        public boolean isFinal() {
            return this.setterMethod == null;
        }
    }
}

