/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.minimalj.model.CodeItem;
import org.minimalj.model.Rendering;
import org.minimalj.util.LocaleContext;

public class EnumUtils {
    private static Map itemLists = new HashMap();

    public static <T extends Enum<T>> T createEnum(Class<T> clazz, String name) {
        try {
            Method[] methods;
            Constructor<?> con = null;
            for (Constructor<?> c : clazz.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != 2) continue;
                con = c;
                break;
            }
            if (con == null) {
                throw new IllegalArgumentException(clazz.getName() + " must have empty constructor");
            }
            for (Method m : methods = con.getClass().getDeclaredMethods()) {
                if (!m.getName().equals("acquireConstructorAccessor")) continue;
                m.setAccessible(true);
                m.invoke(con, new Object[0]);
            }
            Field[] fields = con.getClass().getDeclaredFields();
            Object ca = null;
            for (Field f : fields) {
                if (!f.getName().equals("constructorAccessor")) continue;
                f.setAccessible(true);
                ca = f.get(con);
            }
            Method m = ca.getClass().getMethod("newInstance", Object[].class);
            m.setAccessible(true);
            Enum v = (Enum)m.invoke(ca, new Object[]{new Object[]{name, Integer.MAX_VALUE}});
            return (T)v;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public static <T extends Enum<T>> T getDefault(Class<T> enumClass) {
        return (T)((Enum)EnumUtils.valueList(enumClass).get(0));
    }

    public static <T extends Enum<T>> List<T> valueList(Class<T> enumClass) {
        try {
            Method method = enumClass.getMethod("values", new Class[0]);
            Enum[] values = (Enum[])method.invoke(null, new Object[0]);
            return Arrays.asList(values);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException(x);
        }
    }

    public static <T extends Enum<T>> String getText(T enumElement) {
        String text;
        if (enumElement == null) {
            return null;
        }
        if (enumElement instanceof Rendering && (text = ((Rendering)((Object)enumElement)).render(Rendering.RenderType.PLAIN_TEXT)) != null) {
            return text;
        }
        String bundleName = enumElement.getClass().getName();
        while (true) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName, LocaleContext.getCurrent());
                return resourceBundle.getString(enumElement.name());
            }
            catch (MissingResourceException mre) {
                int pos = bundleName.lastIndexOf(36);
                if (pos < 0) {
                    return enumElement.name();
                }
                bundleName = bundleName.substring(0, pos);
                continue;
            }
            break;
        }
    }

    public static <T extends Enum<T>> String getDescription(T enumElement) {
        if (enumElement == null) {
            return null;
        }
        String bundleName = enumElement.getClass().getName();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName);
            return resourceBundle.getString(enumElement.name() + ".tooltip");
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public static <T extends Enum<T>> List<CodeItem<T>> itemList(Class<T> enumClass) {
        if (!itemLists.containsKey(enumClass)) {
            List<T> values = EnumUtils.valueList(enumClass);
            List<CodeItem<T>> itemList = EnumUtils.itemList(values);
            itemLists.put(enumClass, itemList);
        }
        return (List)itemLists.get(enumClass);
    }

    public static <T extends Enum<T>> List<CodeItem<T>> itemList(List<T> values) {
        ArrayList<CodeItem<T>> itemList = new ArrayList<CodeItem<T>>(values.size());
        for (Enum value : values) {
            CodeItem<Enum> item = new CodeItem<Enum>(value, EnumUtils.getText(value), EnumUtils.getDescription(value));
            itemList.add(item);
        }
        return itemList;
    }

    public static int getInt(Set set, Class enumClass) {
        List values = EnumUtils.valueList(enumClass);
        int bitValue = 1;
        int result = 0;
        for (Object v : values) {
            if (set.contains(v)) {
                result += bitValue;
            }
            bitValue <<= 1;
        }
        return result;
    }

    public static void fillSet(int integer, Class enumClass, Set set) {
        List values = EnumUtils.valueList(enumClass);
        int bitValue = 1;
        for (Object v : values) {
            if ((integer & bitValue) != 0) {
                set.add(v);
            }
            bitValue <<= 1;
        }
    }
}

