/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.page;

import java.util.ArrayList;
import java.util.List;
import org.minimalj.application.Configuration;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.page.CombinedSearchPage;
import org.minimalj.frontend.page.Page;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.resources.Resources;

public abstract class SearchPage<T>
extends Page
implements Frontend.TableActionListener<T> {
    private final String query;
    private final Object[] keys;
    private transient List<T> list;

    public SearchPage(String query, Object[] keys) {
        this.keys = keys;
        String separator = Configuration.get("MjSearchQualifierSeparator", ":");
        int pos = query.indexOf(separator);
        if (pos > 0 && pos < query.length() - 1) {
            String searchQualifier = query.substring(0, pos).toLowerCase();
            this.query = this.getQualifier().startsWith(searchQualifier) ? query.substring(pos + 1) : null;
        } else {
            this.query = query;
        }
    }

    protected abstract List<T> load(String var1);

    @Override
    public Frontend.IContent getContent() {
        Frontend.ITable<T> table = Frontend.getInstance().createTable(this.keys, false, this);
        table.setObjects(this.getList());
        return table;
    }

    public long getCount() {
        return this.getList().size();
    }

    private List<T> getList() {
        if (this.list == null) {
            this.list = this.load(this.query);
        }
        return this.list;
    }

    protected Class<T> getClazz() {
        return GenericUtils.getGenericClass(this.getClass());
    }

    protected abstract Page createDetailPage(T var1);

    @Override
    public String getTitle() {
        return this.getName() + " / " + this.query;
    }

    protected String getQualifier() {
        return this.getName().toLowerCase();
    }

    @Override
    public void action(T selectedObject) {
        Page detailPage = this.createDetailPage(selectedObject);
        if (detailPage != null) {
            Frontend.show(detailPage);
        }
    }

    public String getName() {
        Class<?> genericClass = GenericUtils.getGenericClass(this.getClass());
        return Resources.getString(genericClass);
    }

    public static Page handle(SearchPage ... searchPages) {
        ArrayList<SearchPage> searchPagesWithResult = new ArrayList<SearchPage>();
        for (SearchPage searchPage : searchPages) {
            if (searchPage.getCount() <= 0L) continue;
            searchPagesWithResult.add(searchPage);
        }
        if (searchPagesWithResult.size() == 1) {
            SearchPage searchPage = (SearchPage)searchPagesWithResult.get(0);
            if (searchPage.getCount() == 1L) {
                Object singleSearchResult = searchPage.list.get(0);
                Page detailPage = searchPage.createDetailPage(singleSearchResult);
                return detailPage != null ? detailPage : searchPage;
            }
            return searchPage;
        }
        return new CombinedSearchPage(searchPagesWithResult);
    }
}

