/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.minimalj.frontend.page.Page;

public class PageStore {
    private final Map<String, PageStoreEntry> pagesById = new HashMap<String, PageStoreEntry>();

    public String put(Page page) {
        String pageId = UUID.randomUUID().toString();
        PageStoreEntry entry = new PageStoreEntry(page);
        this.pagesById.put(pageId, entry);
        return pageId;
    }

    public Page get(String pageId) {
        if (this.pagesById.containsKey(pageId)) {
            PageStoreEntry entry = this.pagesById.get(pageId);
            return entry.getPage();
        }
        throw new IllegalStateException(pageId);
    }

    private static class PageStoreEntry {
        private final Page page;
        private long lastUsed;

        public PageStoreEntry(Page page) {
            this.page = page;
            this.updateLastUsed();
        }

        public void updateLastUsed() {
            this.lastUsed = System.currentTimeMillis();
        }

        public Page getPage() {
            return this.page;
        }
    }
}

