/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.minimalj.frontend.page.Page;

public class PageList {
    private final List<String> pageIds = new ArrayList<String>();
    private final List<Page> pages = new ArrayList<Page>();

    public void put(String pageId, Page page) {
        Objects.nonNull(pageId);
        Objects.nonNull(page);
        this.pageIds.add(pageId);
        this.pages.add(page);
    }

    public String getId(int index) {
        return this.pageIds.get(index);
    }

    public String getId(Page page) {
        int index = this.indexOf(page);
        return this.getId(index);
    }

    public int indexOf(Page page) {
        return this.pages.indexOf(page);
    }

    public boolean contains(Page page) {
        return this.pages.contains(page);
    }

    public void clear() {
        this.pageIds.clear();
        this.pages.clear();
    }

    public void removeAllFrom(String pageId) {
        int pagePos = this.pageIds.indexOf(pageId);
        if (pagePos < 0) {
            throw new IllegalArgumentException(pageId + " not a visible page");
        }
        this.removeAllFrom(pagePos);
    }

    public void removeAllAfter(String pageId) {
        int pagePos = this.pageIds.indexOf(pageId);
        if (pagePos < 0) {
            throw new IllegalArgumentException(pageId + " not a visible page");
        }
        this.removeAllFrom(pagePos + 1);
    }

    public void removeAllFrom(Page page) {
        int pagePos = this.pages.indexOf(page);
        if (pagePos < 0) {
            throw new IllegalArgumentException(page + " not a visible page");
        }
        this.removeAllFrom(pagePos);
    }

    private void removeAllFrom(int pagePos) {
        for (int i = this.pageIds.size() - 1; i >= pagePos; --i) {
            this.pages.remove(i);
            this.pageIds.remove(i);
        }
    }
}

