/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.util;

import java.util.ArrayList;
import java.util.List;

public class History<T> {
    private final List<T> history = new ArrayList<T>();
    private final HistoryListener historyListener;
    private T present;
    private int presentIndex = -1;

    public History(HistoryListener historyListener) {
        this.historyListener = historyListener;
    }

    public void add(T page) {
        this.add(page, false);
    }

    public void addQuiet(T page) {
        this.add(page, true);
    }

    private void add(T page, boolean quiet) {
        if (!page.equals(this.present)) {
            int indexToRemove = this.history.size() - 1;
            while (indexToRemove > this.presentIndex) {
                this.history.remove(indexToRemove--);
            }
            this.present = page;
            this.history.add(page);
            this.presentIndex = this.history.size() - 1;
        }
        if (!quiet) {
            this.fireHistoryChanged();
        }
    }

    private void fireHistoryChanged() {
        this.historyListener.onHistoryChanged();
    }

    public void replace(T page) {
        this.history.set(this.presentIndex, page);
        this.present = page;
        this.fireHistoryChanged();
    }

    private void moveTo(T page) {
        this.present = page;
        this.fireHistoryChanged();
    }

    public void next() {
        this.moveTo(this.history.get(++this.presentIndex));
    }

    public void previous() {
        this.moveTo(this.history.get(--this.presentIndex));
    }

    public void dropFuture() {
        for (int i = this.history.size() - 1; i > this.presentIndex; --i) {
            this.history.remove(i);
        }
        this.fireHistoryChanged();
    }

    public T getPresent() {
        return this.present;
    }

    public boolean hasFuture() {
        return this.present != null && this.presentIndex < this.history.size() - 1;
    }

    public boolean hasPast() {
        return this.present != null && this.presentIndex > 0;
    }

    public void clear() {
        this.history.clear();
    }

    public static interface HistoryListener {
        public void onHistoryChanged();
    }
}

