/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.component.SwingDecoration;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.model.Keys;
import org.minimalj.model.Rendering;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.Sortable;
import org.minimalj.util.resources.Resources;

public class SwingTable<T>
extends JScrollPane
implements Frontend.ITable<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SwingTable.class.getName());
    private static final int PAGE_SIZE = 50;
    private final Object[] keys;
    private final List<PropertyInterface> properties;
    private final JTable table;
    private final ItemTableModel tableModel;
    private final Frontend.TableActionListener<T> listener;
    private final JButton nextButton;
    private final JButton prevButton;
    private List<T> list;
    private int offset;

    public SwingTable(Object[] keys, boolean multiSelect, Frontend.TableActionListener<T> listener) {
        this.keys = keys;
        this.listener = listener;
        this.properties = this.convert(keys);
        this.tableModel = new ItemTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(multiSelect ? 2 : 0);
        this.table.setRowSelectionAllowed(true);
        this.table.setFillsViewportHeight(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.table.setDefaultRenderer(Object.class, new RenderingTableCellRenderer());
        this.table.setAutoCreateRowSorter(true);
        this.setViewportView(this.table);
        this.bindRowHeightToFont();
        this.table.addMouseListener(new SwingTableMouseListener());
        this.table.getSelectionModel().addListSelectionListener(new SwingTableSelectionListener());
        this.table.getRowSorter().addRowSorterListener(new SwingTableRowSortingListener());
        this.table.getTableHeader().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout());
        panel.setOpaque(false);
        this.prevButton = SwingDecoration.createDecorationButton(SwingDecoration.Part.PREV);
        this.prevButton.addActionListener(e -> this.setOffset(this.offset - 50));
        this.prevButton.setVisible(false);
        panel.add(this.prevButton);
        this.nextButton = SwingDecoration.createDecorationButton(SwingDecoration.Part.NEXT);
        this.nextButton.addActionListener(e -> this.setOffset(this.offset + 50));
        this.nextButton.setVisible(false);
        panel.add(this.nextButton);
        this.table.getTableHeader().add((Component)panel, "After");
    }

    private List<PropertyInterface> convert(Object[] keys) {
        ArrayList<PropertyInterface> properties = new ArrayList<PropertyInterface>(keys.length);
        for (Object key : keys) {
            PropertyInterface property = Keys.getProperty(key);
            if (property != null) {
                properties.add(property);
                continue;
            }
            logger.log(Level.WARNING, "Key not a property: " + key);
        }
        if (properties.size() == 0) {
            logger.log(Level.SEVERE, "table without valid keys");
        }
        return properties;
    }

    private void bindRowHeightToFont() {
        PropertyChangeListener listener = event -> this.table.setRowHeight(this.table.getFont().getSize() * 5 / 3 + 2);
        listener.propertyChange(null);
        this.table.addPropertyChangeListener("UI", listener);
    }

    @Override
    public void setObjects(List<T> list) {
        this.list = list;
        this.setOffset(0);
        this.setSortableColumns(list);
    }

    private void setSortableColumns(List<T> list) {
        if (this.table.getRowSorter() instanceof DefaultRowSorter) {
            DefaultRowSorter sorter = (DefaultRowSorter)this.table.getRowSorter();
            Sortable sortable = null;
            if (list instanceof Sortable) {
                sortable = (Sortable)((Object)list);
            }
            for (int i = 0; i < this.keys.length; ++i) {
                sorter.setSortable(i, sortable != null && sortable.canSortBy(this.keys[i]));
            }
        }
    }

    private void setOffset(int offset) {
        this.offset = offset;
        this.tableModel.setObjects(this.list.subList(offset, Math.min(this.list.size(), offset + 50)));
        this.nextButton.setVisible(this.list.size() > offset + 50);
        this.prevButton.setVisible(offset > 0);
    }

    public List<T> getSelectedObjects() {
        ArrayList selectedIds = new ArrayList(this.table.getSelectedRowCount());
        for (int row : this.table.getSelectedRows()) {
            int rowInModel = this.table.convertRowIndexToModel(row);
            selectedIds.add(this.tableModel.getObject(rowInModel));
        }
        return selectedIds;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension header = this.table.getTableHeader().getMinimumSize();
        return new Dimension(0, header.height + 10 * this.table.getRowHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension minimum = this.getMinimumSize();
        return new Dimension(30000, minimum.height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(30000, 30000);
    }

    private class RenderingTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private RenderingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PropertyInterface property = (PropertyInterface)SwingTable.this.properties.get(column);
            value = Rendering.render(value, Rendering.RenderType.PLAIN_TEXT, property);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    public class ItemTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<T> objects = Collections.emptyList();

        public void setObjects(List<T> objects) {
            this.objects = objects;
            this.fireTableDataChanged();
        }

        public List<T> getObjects() {
            return this.objects;
        }

        public T getObject(int index) {
            return this.objects.get(index);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            PropertyInterface property = (PropertyInterface)SwingTable.this.properties.get(column);
            return Resources.getPropertyName(property);
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                Object object = this.getObject(row);
                PropertyInterface property = (PropertyInterface)SwingTable.this.properties.get(column);
                return property.getValue(object);
            }
            catch (Exception x) {
                logger.severe("Couldn't get value for " + row + "/" + column + ": " + x.getMessage());
                return row + "/" + column + ": " + x.getMessage();
            }
        }

        @Override
        public int getRowCount() {
            return this.objects.size();
        }

        @Override
        public int getColumnCount() {
            return SwingTable.this.keys.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<?> clazz = ((PropertyInterface)SwingTable.this.properties.get(columnIndex)).getClazz();
            if (Rendering.class.isAssignableFrom(clazz)) {
                return Rendering.class;
            }
            return clazz;
        }
    }

    private class SwingTableRowSortingListener
    implements RowSorterListener {
        private SwingTableRowSortingListener() {
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                List<RowSorter.SortKey> sortKeys = ((RowSorter)e.getSource()).getSortKeys();
                Object[] keys = new Object[sortKeys.size()];
                boolean[] directions = new boolean[sortKeys.size()];
                int index = 0;
                for (RowSorter.SortKey s : sortKeys) {
                    keys[index] = SwingTable.this.keys[s.getColumn()];
                    directions[index] = s.getSortOrder() == SortOrder.ASCENDING;
                    ++index;
                }
                if (SwingTable.this.list instanceof Sortable) {
                    ((Sortable)((Object)SwingTable.this.list)).sort(keys, directions);
                }
                SwingTable.this.setOffset(0);
            }
        }
    }

    private class SwingTableSelectionListener
    implements ListSelectionListener {
        private SwingTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && SwingTable.this.table.isShowing()) {
                SwingFrontend.runWithContext(() -> SwingTable.this.listener.selectionChanged(SwingTable.this.getSelectedObjects()));
            }
        }
    }

    private class SwingTableMouseListener
    extends MouseAdapter {
        private SwingTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && SwingTable.this.listener != null) {
                int row = SwingTable.this.table.rowAtPoint(e.getPoint());
                if (e.getClickCount() == 2 && row >= 0) {
                    int rowInModel = SwingTable.this.table.convertRowIndexToModel(row);
                    SwingFrontend.runWithContext(() -> SwingTable.this.listener.action(SwingTable.this.tableModel.getObject(rowInModel)));
                }
            }
        }
    }
}

