/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.toolkit.SwingTable;

public class SwingSearchPanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JTextField text = new JTextField();
    private final JButton searchButton = new JButton("Search");
    private final SwingTable<T> table;

    public SwingSearchPanel(final Frontend.Search<T> search, Object[] keys, Frontend.TableActionListener<T> listener) {
        super(new BorderLayout());
        this.table = new SwingTable<T>(keys, false, listener);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.text, "Center");
        northPanel.add((Component)this.searchButton, "East");
        this.add(SwingSearchPanel.border(northPanel, 5, 5, 5, 5), "North");
        this.add(this.table, "Center");
        this.text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingSearchPanel.this.searchButton.doClick();
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List objects = search.search(SwingSearchPanel.this.text.getText());
                SwingSearchPanel.this.table.setObjects(objects);
            }
        });
    }

    private static Component border(Component component, int top, int left, int bottom, int right) {
        JComponent jComponent;
        if (component instanceof JComponent) {
            jComponent = (JComponent)component;
        } else {
            jComponent = new JPanel(new BorderLayout());
            jComponent.add(component, "Center");
        }
        jComponent.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        return jComponent;
    }
}

