/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;

public class SwingList
extends JPanel
implements Frontend.IList {
    private static final long serialVersionUID = 1L;
    private final int actionCount;
    private Component[] disabledChildren;

    public SwingList(Action ... actions) {
        super(null, true);
        this.setLayout(new VerticalLayoutManager());
        if (actions != null) {
            for (Action action : actions) {
                this.add((Component)new SwingFrontend.SwingActionText(action), "");
            }
            this.actionCount = actions.length;
        } else {
            this.actionCount = 0;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setOpaque(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() && !enabled) {
            this.disabledChildren = this.getComponents();
            this.removeAll();
        } else if (!this.isEnabled() && enabled) {
            for (Component c : this.disabledChildren) {
                this.add(c, "");
            }
        } else {
            return;
        }
        this.revalidate();
        super.setEnabled(enabled);
    }

    @Override
    public void clear() {
        for (int i = this.getComponentCount() - this.actionCount - 1; i >= 0; --i) {
            this.remove(i);
        }
        if (this.disabledChildren != null) {
            this.disabledChildren = Arrays.copyOfRange(this.disabledChildren, this.disabledChildren.length - this.actionCount, this.disabledChildren.length);
        }
        this.revalidate();
    }

    @Override
    public void add(Frontend.IComponent component, Action ... actions) {
        JComponent lastLabel;
        boolean enabled = this.isEnabled();
        this.setEnabled(true);
        int existingComponents = this.getComponentCount();
        super.add((Component)((Object)component), "", this.getComponentCount() - this.actionCount);
        for (Action action : actions) {
            super.add(new SwingFrontend.SwingActionText(action), "", this.getComponentCount() - this.actionCount);
        }
        if (this.actionCount > 0) {
            lastLabel = (JComponent)super.getComponent(this.getComponentCount() - this.actionCount - 1);
            lastLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        } else if (existingComponents > 0) {
            lastLabel = (JComponent)super.getComponent(existingComponents - 1);
            lastLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        }
        this.setEnabled(enabled);
        this.repaint();
        this.revalidate();
    }

    private class VerticalLayoutManager
    implements LayoutManager {
        private Dimension preferredSize;
        private Rectangle lastParentBounds = null;

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            int verticalInset;
            if (this.lastParentBounds != null && this.lastParentBounds.equals(parent.getBounds())) {
                return;
            }
            this.lastParentBounds = parent.getBounds();
            int preferredHeight = 0;
            for (Component component : SwingList.this.getComponents()) {
                int height = component.getPreferredSize().height;
                preferredHeight += height;
            }
            int verticalRest = parent.getHeight() - preferredHeight;
            int y = verticalInset = verticalRest > 8 ? 4 : verticalRest / 2;
            int x = verticalInset > 0 ? 1 : 0;
            int width = parent.getWidth();
            int widthWithoutIns = width - x;
            for (Component component : SwingList.this.getComponents()) {
                int height = component.getPreferredSize().height;
                component.setBounds(x, y, widthWithoutIns, height);
                y += height;
            }
            this.preferredSize = new Dimension(width, preferredHeight);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.lastParentBounds = null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.lastParentBounds = null;
        }
    }
}

