/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.minimalj.frontend.Frontend;

public class SwingImage
extends JPanel
implements Frontend.Input<byte[]> {
    private static final long serialVersionUID = 1L;
    private final Frontend.InputComponentListener changeListener;
    private final int size;
    private final JLabel image;
    private final JPanel controlPanel;
    private final JLabel selectActionLabel;
    private final JLabel removeActionLabel;
    private byte[] imageData;
    private ImageIcon icon;

    public SwingImage(int size, Frontend.InputComponentListener changeListener) {
        super(new BorderLayout(6, 0));
        boolean editable;
        this.changeListener = changeListener;
        this.size = size;
        this.image = new JLabel();
        this.add((Component)this.image, "Before");
        boolean bl = editable = changeListener != null;
        if (editable) {
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new GridLayout(2, 1));
            this.removeActionLabel = new SwingRemoveActionLabel();
            this.removeActionLabel.setVerticalAlignment(1);
            if (this.icon != null) {
                this.controlPanel.add(this.removeActionLabel);
            }
            this.selectActionLabel = new SwingSelectActionLabel();
            this.selectActionLabel.setVerticalAlignment(3);
            this.controlPanel.add(this.selectActionLabel);
            this.add((Component)this.controlPanel, "Center");
        } else {
            this.controlPanel = null;
            this.selectActionLabel = null;
            this.removeActionLabel = null;
        }
    }

    @Override
    public void setValue(byte[] imageData) {
        this.imageData = imageData;
        if (imageData != null) {
            this.icon = new ImageIcon(imageData);
            int preferredHeight = this.getPreferredSize().height;
            if (this.icon.getIconHeight() > preferredHeight) {
                int newWidth = this.icon.getIconWidth() * preferredHeight / this.icon.getIconHeight();
                this.icon = new ImageIcon(this.icon.getImage().getScaledInstance(newWidth, preferredHeight, 4));
            }
        } else {
            this.icon = null;
        }
        this.image.setIcon(this.icon);
        if (this.controlPanel != null) {
            if (this.icon != null && this.removeActionLabel.getParent() == null) {
                this.controlPanel.add((Component)this.removeActionLabel, 0);
            } else if (this.icon == null && this.removeActionLabel.getParent() != null) {
                this.controlPanel.remove(this.removeActionLabel);
            }
        }
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().repaint();
        }
    }

    @Override
    public byte[] getValue() {
        return this.imageData;
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable && !this.isEditable()) {
            if (this.changeListener == null) {
                throw new IllegalStateException("SwingImage cannot set to editable without a changeListener");
            }
            this.add((Component)this.controlPanel, "Center");
        } else if (!editable && this.isEditable()) {
            this.remove(this.controlPanel);
        }
    }

    public boolean isEditable() {
        return this.controlPanel != null && this.controlPanel.getParent() == this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(super.getPreferredSize());
        if (this.icon != null) {
            JTextField textField = new JTextField();
            int textFieldHeight = textField.getPreferredSize().height;
            d.height = textFieldHeight * this.size;
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    private class SwingSelectActionLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public SwingSelectActionLabel() {
            super("[+]");
            this.setForeground(Color.BLUE);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(0);
                    if (0 == chooser.showDialog(SwingImage.this, "Bild w\u00e4hlen")) {
                        File file = chooser.getSelectedFile();
                        try (FileInputStream fis = new FileInputStream(file);){
                            byte[] bytes = new byte[fis.available()];
                            fis.read(bytes);
                            SwingImage.this.setValue(bytes);
                            SwingImage.this.changeListener.changed(SwingImage.this);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private class SwingRemoveActionLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public SwingRemoveActionLabel() {
            super("[x]");
            this.setForeground(Color.BLUE);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingImage.this.setValue(null);
                    SwingImage.this.changeListener.changed(SwingImage.this);
                }
            });
        }
    }
}

