/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.component.SwingCaption;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;

public class SwingFormContent
extends JPanel
implements Frontend.FormContent {
    private static final long serialVersionUID = 1L;
    private final int columnWidth;
    private final Map<Frontend.IComponent, SwingCaption> captionByComponent = new HashMap<Frontend.IComponent, SwingCaption>();

    public SwingFormContent(int columns, int columnWidthPercentage) {
        this.columnWidth = this.getColumnWidth() * columnWidthPercentage / 100;
        this.setLayout(new GridFormLayoutManager(columns, this.columnWidth, 5));
        this.setBorder(null);
    }

    private int getColumnWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return (int)fm.getStringBounds("The quick brown fox jumps over the lazy dog", this.getGraphics()).getWidth();
    }

    @Override
    public void add(Frontend.IComponent c) {
        Component component = (Component)((Object)c);
        this.add(component, new GridFormLayoutConstraint(SwingFrontend.verticallyGrowing(component)));
    }

    @Override
    public void add(String caption, Frontend.IComponent c, int span) {
        Component component = (Component)((Object)c);
        SwingCaption swingCaption = new SwingCaption(component, caption);
        this.captionByComponent.put(c, swingCaption);
        this.add((Component)swingCaption, new GridFormLayoutConstraint(span, SwingFrontend.verticallyGrowing(component)));
    }

    @Override
    public void setValidationMessages(Frontend.IComponent component, List<String> validationMessages) {
        SwingCaption swingCaption = this.captionByComponent.get(component);
        if (swingCaption != null) {
            swingCaption.setValidationMessages(validationMessages);
        }
    }

    private static class GridFormLayoutManager
    implements LayoutManager2 {
        private final int columns;
        private final int minColumnWidth;
        private final int ins;
        private final List<List<Component>> rows = new LinkedList<List<Component>>();
        private final Map<Component, GridFormLayoutConstraint> constraints = new HashMap<Component, GridFormLayoutConstraint>();
        private Dimension size;
        private Rectangle lastParentBounds = null;
        private int column = Integer.MAX_VALUE;

        public GridFormLayoutManager(int columns, int minColumnWidth, int ins) {
            this.columns = columns;
            this.minColumnWidth = minColumnWidth;
            this.ins = ins;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.size;
        }

        @Override
        public void layoutContainer(Container parent) {
            if (this.lastParentBounds != null && this.lastParentBounds.equals(parent.getBounds())) {
                return;
            }
            this.lastParentBounds = parent.getBounds();
            int fixHeight = this.calcFixHeight(true);
            int fixHeightWithoutCaption = this.calcFixHeight(false);
            int y = this.ins;
            int width = parent.getWidth();
            int widthWithoutIns = width - 2 * this.ins;
            for (List<Component> row : this.rows) {
                boolean hasCaption = this.hasCaption(row);
                int height = this.isRowVerticallyGrowing(row) ? Math.max(this.getHeight(row), fixHeight) : (hasCaption ? fixHeight : fixHeightWithoutCaption);
                this.layoutRow(widthWithoutIns, row, y, height, hasCaption ? fixHeight : fixHeightWithoutCaption);
                y += height;
            }
            this.size = new Dimension(Math.max(this.minColumnWidth * this.columns, width), y += this.ins);
        }

        private void layoutRow(int width, List<Component> row, int y, int height, int minimalHeight) {
            int x = this.ins;
            for (Component component : row) {
                component.setLocation(x, y);
                GridFormLayoutConstraint constraint = this.constraints.get(component);
                int componentWidth = constraint.isCompleteRow() ? width : constraint.getSpan() * width / this.columns;
                x += componentWidth;
                if (constraint.isVerticallyGrowing()) {
                    component.setSize(componentWidth, height);
                    continue;
                }
                component.setSize(componentWidth, Math.max(component.getPreferredSize().height, minimalHeight));
            }
        }

        private int getHeight(List<Component> row) {
            int height = 0;
            for (Component component : row) {
                height = Math.max(height, component.getPreferredSize().height);
            }
            return height;
        }

        private boolean isRowVerticallyGrowing(List<Component> row) {
            for (Component component : row) {
                GridFormLayoutConstraint constraint = this.constraints.get(component);
                if (!constraint.isVerticallyGrowing()) continue;
                return true;
            }
            return false;
        }

        private boolean hasCaption(List<Component> row) {
            for (Component component : row) {
                if (!(component instanceof SwingCaption)) continue;
                return true;
            }
            return false;
        }

        private int calcFixHeight(boolean caption) {
            int height = 0;
            for (List<Component> row : this.rows) {
                for (Component component : row) {
                    boolean hasCaption;
                    if (SwingFrontend.verticallyGrowing(component) || (hasCaption = component instanceof SwingCaption) != caption) continue;
                    height = Math.max(height, component.getPreferredSize().height);
                }
            }
            return height;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraint) {
            List<Object> row;
            GridFormLayoutConstraint formConstraint = (GridFormLayoutConstraint)constraint;
            this.constraints.put(comp, formConstraint);
            if (this.column >= this.columns) {
                row = new ArrayList();
                this.rows.add(row);
                this.column = 0;
            } else {
                row = this.rows.get(this.rows.size() - 1);
            }
            row.add(comp);
            this.column = formConstraint.isCompleteRow() ? this.columns : this.column + formConstraint.getSpan();
            this.lastParentBounds = null;
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(30000, 30000);
        }

        @Override
        public void invalidateLayout(Container target) {
            this.lastParentBounds = null;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static class GridFormLayoutConstraint {
        private final int span;
        private final boolean verticallyGrowing;

        public GridFormLayoutConstraint(boolean verticallyGrowing) {
            this(0, verticallyGrowing);
        }

        public GridFormLayoutConstraint(int span, boolean verticallyGrowing) {
            this.span = span;
            this.verticallyGrowing = verticallyGrowing;
        }

        protected int getSpan() {
            return this.span;
        }

        protected boolean isVerticallyGrowing() {
            return this.verticallyGrowing;
        }

        public boolean isCompleteRow() {
            return this.span < 1;
        }
    }
}

