/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.component;

import com.sun.javafx.application.PlatformImpl;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.minimalj.frontend.Frontend;
import org.minimalj.util.StringUtils;

public class SwingHtmlContent
extends JFXPanel
implements Frontend.IContent {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SwingHtmlContent(String htmlOrUrl) {
        String html;
        String url;
        Platform.setImplicitExit((boolean)false);
        if (htmlOrUrl.startsWith("<")) {
            url = null;
            html = htmlOrUrl;
        } else if (StringUtils.isUrl(htmlOrUrl)) {
            url = htmlOrUrl;
            html = null;
        } else if (htmlOrUrl.endsWith(".html")) {
            URL resource = this.getClass().getClassLoader().getResource(htmlOrUrl);
            if (resource == null) throw new IllegalArgumentException("Invalid content: " + htmlOrUrl);
            url = resource.toExternalForm();
            html = null;
        } else {
            url = null;
            html = "<html>" + StringUtils.escapeHTML(htmlOrUrl) + "</html>";
        }
        PlatformImpl.startup((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView webBrowser = new WebView();
                AnchorPane.setTopAnchor((Node)webBrowser, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)webBrowser, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)webBrowser, (Double)0.0);
                AnchorPane.setRightAnchor((Node)webBrowser, (Double)0.0);
                AnchorPane anchorPane = new AnchorPane();
                anchorPane.getChildren().add((Object)webBrowser);
                Scene scene = new Scene((Parent)anchorPane);
                WebEngine webEngine = webBrowser.getEngine();
                if (html != null) {
                    webEngine.loadContent(html);
                } else {
                    webEngine.load(url);
                }
                SwingHtmlContent.this.setScene(scene);
            }
        });
    }
}

