/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class HideableTabbedPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private final Map<Component, String> titles = new HashMap<Component, String>();
    private final Map<Component, String> tooltips = new HashMap<Component, String>();
    private final Map<Component, Icon> icons = new HashMap<Component, Icon>();

    public HideableTabbedPane() {
        super(new BorderLayout());
    }

    public void addTab(String title, Component tab) {
        this.addTab(title, null, tab, null);
    }

    public void addTab(String title, Icon icon, Component tab, String tip) {
        this.titles.put(tab, title);
        this.icons.put(tab, icon);
        this.tooltips.put(tab, tip);
        if (this.getComponentCount() == 0) {
            this.add(tab, "Center");
        } else if (this.tabbedPane != null) {
            this.tabbedPane.addTab(title, icon, tab, tip);
        } else {
            this.tabbedPane = new JTabbedPane();
            Component firstComponent = this.getComponent(0);
            this.remove(firstComponent);
            this.tabbedPane.addTab(this.titles.get(firstComponent), this.icons.get(firstComponent), firstComponent, this.tooltips.get(firstComponent));
            this.tabbedPane.addTab(title, icon, tab, tip);
            this.add((Component)this.tabbedPane, "Center");
        }
    }

    public void removeTab(JComponent tab) {
        this.titles.remove(tab);
        this.icons.remove(tab);
        this.tooltips.remove(tab);
        if (this.tabbedPane != null) {
            this.tabbedPane.remove(tab);
            if (this.tabbedPane.getComponentCount() == 1) {
                Component firstComponent = this.tabbedPane.getComponentAt(0);
                this.remove(this.tabbedPane);
                this.tabbedPane = null;
                this.add(firstComponent, "Center");
            } else {
                this.tabbedPane.remove(tab);
            }
        } else if (this.getComponentCount() > 0 && this.getComponent(0).equals(tab)) {
            this.remove(tab);
        }
    }

    public void removeAllTabs() {
        this.titles.clear();
        this.icons.clear();
        this.tooltips.clear();
        this.tabbedPane = null;
        this.removeAll();
        this.revalidate();
    }

    public int getTabCount() {
        if (this.getComponentCount() == 0) {
            return 0;
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.getTabCount();
        }
        return 1;
    }

    public Component getTab(int index) {
        if (this.getComponentCount() == 0) {
            return null;
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.getComponentAt(index);
        }
        return this.getComponent(0);
    }

    public void setSelectedComponent(Component component) {
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedComponent(component);
        }
    }

    public Component getSelectedComponent() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.getSelectedComponent();
        }
        return this.getComponent(0);
    }

    public void setTitleAt(int index, String title) {
        this.titles.put(this.getTab(index), title);
        if (this.tabbedPane != null) {
            this.tabbedPane.setTitleAt(index, title);
        }
    }

    @Deprecated
    public void setIconAt(int index, Icon titleIcon) {
        this.icons.put(this.getTab(index), titleIcon);
        if (this.tabbedPane != null) {
            this.tabbedPane.setIconAt(index, titleIcon);
        }
    }

    @Deprecated
    public void setToolTipTextAt(int index, String titleToolTip) {
        this.tooltips.put(this.getTab(index), titleToolTip);
        if (this.tabbedPane != null) {
            this.tabbedPane.setToolTipTextAt(index, titleToolTip);
        }
    }
}

