/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.minimalj.application.Application;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.ActionGroup;
import org.minimalj.frontend.action.Separator;
import org.minimalj.frontend.impl.swing.NavigationTree;
import org.minimalj.frontend.impl.swing.SwingFrame;
import org.minimalj.frontend.impl.swing.SwingMenuBar;
import org.minimalj.frontend.impl.swing.SwingResourceAction;
import org.minimalj.frontend.impl.swing.SwingToolBar;
import org.minimalj.frontend.impl.swing.component.EditablePanel;
import org.minimalj.frontend.impl.swing.component.SwingDecoration;
import org.minimalj.frontend.impl.swing.toolkit.SwingEditorPanel;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.frontend.impl.swing.toolkit.SwingInternalFrame;
import org.minimalj.frontend.impl.swing.toolkit.SwingProgressInternalFrame;
import org.minimalj.frontend.impl.swing.toolkit.SwingSearchPanel;
import org.minimalj.frontend.impl.util.History;
import org.minimalj.frontend.page.IDialog;
import org.minimalj.frontend.page.Page;
import org.minimalj.frontend.page.PageManager;
import org.minimalj.frontend.page.ProgressListener;

public class SwingTab
extends EditablePanel
implements PageManager {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PAGES_UNLIMITED = 0;
    public static final int MAX_PAGES_ADPATIV = -1;
    final SwingFrame frame;
    final Action previousAction;
    final Action nextAction;
    final Action refreshAction;
    final Action closeTabAction;
    final Action navigationAction;
    final ScrollToNewPageAction scrollToNewPageAction;
    private final SwingToolBar toolBar;
    private final SwingMenuBar menuBar;
    private final JSplitPane splitPane;
    private final SwingDecoration decoratedNavigationPane;
    private final JScrollPane contentScrollPane;
    private final JPanel verticalPanel;
    private final JScrollPane navigationScrollPane;
    private final History<List<Page>> history;
    private final SwingTabHistoryListener historyListener;
    private final List<Page> visiblePageAndDetailsList;
    private int maxPages;

    public SwingTab(SwingFrame frame) {
        this.frame = frame;
        this.historyListener = new SwingTabHistoryListener();
        this.history = new History(this.historyListener);
        this.visiblePageAndDetailsList = new ArrayList<Page>();
        this.previousAction = new PreviousPageAction();
        this.nextAction = new NextPageAction();
        this.refreshAction = new RefreshAction();
        this.closeTabAction = new CloseTabAction();
        this.navigationAction = new NavigationAction();
        this.scrollToNewPageAction = new ScrollToNewPageAction();
        JPanel outerPanel = new JPanel(new BorderLayout());
        this.menuBar = new SwingMenuBar(this);
        outerPanel.add((Component)this.menuBar, "North");
        this.setContent(outerPanel);
        JPanel panel = new JPanel(new BorderLayout());
        outerPanel.add((Component)panel, "Center");
        this.toolBar = new SwingToolBar(this);
        panel.add((Component)this.toolBar, "North");
        this.splitPane = new JSplitPane();
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)this.splitPane, "Center");
        this.verticalPanel = new JPanel(new VerticalLayoutManager());
        this.contentScrollPane = new JScrollPane(this.verticalPanel);
        this.contentScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.contentScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setRightComponent(this.contentScrollPane);
        this.navigationScrollPane = new JScrollPane();
        this.updateNavigation();
        this.navigationScrollPane.setBorder(BorderFactory.createEmptyBorder());
        ActionListener navigationClosedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingTab.this.navigationAction.putValue("SwingSelectedKey", Boolean.FALSE);
                SwingTab.this.navigationAction.actionPerformed(e);
            }
        };
        this.decoratedNavigationPane = new SwingDecoration(Application.getInstance().getName(), this.navigationScrollPane, false, navigationClosedListener);
        this.splitPane.setLeftComponent(this.decoratedNavigationPane);
        this.splitPane.setDividerLocation(200);
    }

    public void updateNavigation() {
        this.navigationScrollPane.setViewportView(new NavigationTree(Application.getInstance().getNavigation()));
    }

    public Page getVisiblePage() {
        return this.visiblePageAndDetailsList.get(0);
    }

    void onHistoryChanged() {
        this.updateActions();
        this.toolBar.onHistoryChanged();
        this.frame.onHistoryChanged();
    }

    protected void updateActions() {
        if (this.getVisiblePage() != null) {
            this.previousAction.setEnabled(this.hasPast());
            this.nextAction.setEnabled(this.hasFuture());
        } else {
            this.previousAction.setEnabled(false);
            this.nextAction.setEnabled(false);
        }
    }

    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }

    public boolean hasFuture() {
        return this.history.hasFuture();
    }

    public boolean hasPast() {
        return this.history.hasPast();
    }

    public void next() {
        this.history.next();
    }

    public void previous() {
        this.history.previous();
    }

    @Override
    public void show(Page page) {
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(page);
        this.history.add(pages);
    }

    @Override
    public void showDetail(Page mainPage, Page detail) {
        int index = this.visiblePageAndDetailsList.indexOf(detail);
        if (index > -1) {
            SwingDecoration decoration = (SwingDecoration)this.verticalPanel.getComponents()[index];
            decoration.setTitle(detail.getTitle());
            decoration.setContentVisible();
            return;
        }
        this.removeDetailsOf(mainPage);
        this.addPageOrDetail(detail);
        this.history.addQuiet(new ArrayList<Page>(this.visiblePageAndDetailsList));
    }

    private void addPageOrDetail(final Page page) {
        JComponent content;
        this.visiblePageAndDetailsList.add(page);
        ActionListener closeListener = null;
        if (this.visiblePageAndDetailsList.size() > 1) {
            closeListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingTab.this.hideDetail(page);
                }
            };
        }
        if ((content = (JComponent)((Object)page.getContent())) != null) {
            JPopupMenu menu = this.createMenu(page.getActions());
            content.setComponentPopupMenu(menu);
            this.setInheritMenu(content);
        } else {
            content = new JPanel();
        }
        content.putClientProperty("page", page);
        SwingDecoration newPage = new SwingDecoration(page.getTitle(), content, true, closeListener);
        this.verticalPanel.add((Component)newPage, "");
        this.verticalPanel.revalidate();
        SwingUtilities.invokeLater(() -> this.limitOpenPages(newPage));
    }

    private void limitOpenPages(SwingDecoration newPage) {
        if (this.maxPages > 0) {
            for (int i = 0; i < this.verticalPanel.getComponentCount() - this.maxPages; ++i) {
                SwingDecoration pageDecoration = (SwingDecoration)this.verticalPanel.getComponent(i);
                pageDecoration.minimize();
            }
        } else if (this.maxPages == -1) {
            int available = this.contentScrollPane.getHeight() - (int)newPage.getMinimumSize().getHeight();
            for (int i = this.verticalPanel.getComponentCount() - 2; i >= 0; --i) {
                SwingDecoration pageDecoration = (SwingDecoration)this.verticalPanel.getComponent(i);
                if ((available = (int)((double)available - pageDecoration.getMinimumSize().getHeight())) >= 0) continue;
                pageDecoration.minimize();
            }
        }
        if (this.scrollToNewPageAction.isSelected()) {
            this.contentScrollPane.getVerticalScrollBar().setValue(this.contentScrollPane.getVerticalScrollBar().getMaximum() - newPage.getHeight());
        }
    }

    private void removeDetailsOf(Page page) {
        int index = this.visiblePageAndDetailsList.indexOf(page);
        this.removeDetails(index + 1);
    }

    private void removeDetails(int index) {
        for (int index2 = this.visiblePageAndDetailsList.size() - 1; index2 >= index; --index2) {
            this.visiblePageAndDetailsList.remove(index2);
            this.verticalPanel.remove(this.verticalPanel.getComponentCount() - 1);
        }
        this.verticalPanel.revalidate();
    }

    @Override
    public boolean isDetailShown(Page detail) {
        return this.visiblePageAndDetailsList.contains(detail);
    }

    @Override
    public void hideDetail(Page detail) {
        int index = this.visiblePageAndDetailsList.indexOf(detail);
        this.removeDetails(index);
    }

    @Override
    public void showError(String text) {
        Window window = this.findWindow();
        JOptionPane.showMessageDialog(window, text, "Fehler", 0);
    }

    private Window findWindow() {
        Component parentComponent = this;
        while (parentComponent != null && !(parentComponent instanceof Window)) {
            if (parentComponent instanceof JPopupMenu) {
                parentComponent = ((JPopupMenu)parentComponent).getInvoker();
                continue;
            }
            parentComponent = parentComponent.getParent();
        }
        return (Window)parentComponent;
    }

    @Override
    public IDialog showDialog(String title, Frontend.IContent content, org.minimalj.frontend.action.Action saveAction, org.minimalj.frontend.action.Action closeAction, org.minimalj.frontend.action.Action ... actions) {
        SwingEditorPanel contentComponent = new SwingEditorPanel(content, actions);
        return this.createDialog(title, contentComponent, saveAction, closeAction);
    }

    private IDialog createDialog(String title, JComponent content, org.minimalj.frontend.action.Action saveAction, org.minimalj.frontend.action.Action closeAction) {
        return new SwingInternalFrame(this, title, content, saveAction, closeAction);
    }

    @Override
    public void showMessage(String text) {
        Window window = this.findWindow();
        JOptionPane.showMessageDialog(window, text, "Information", 1);
    }

    @Override
    public <T> IDialog showSearchDialog(Frontend.Search<T> index, Object[] keys, Frontend.TableActionListener<T> listener) {
        SwingSearchPanel<T> panel = new SwingSearchPanel<T>(index, keys, listener);
        return this.createDialog(null, panel, null, null);
    }

    @Deprecated
    public ProgressListener showProgress(String text) {
        SwingProgressInternalFrame frame = new SwingProgressInternalFrame(text);
        this.openModalDialog(frame);
        return frame;
    }

    private JPopupMenu createMenu(List<org.minimalj.frontend.action.Action> actions) {
        if (actions != null && actions.size() > 0) {
            JPopupMenu menu = new JPopupMenu();
            SwingTab.addActions(menu, actions);
            return menu;
        }
        return null;
    }

    public static void addActions(JPopupMenu menu, List<org.minimalj.frontend.action.Action> actions) {
        for (org.minimalj.frontend.action.Action action : actions) {
            if (action instanceof ActionGroup) {
                ActionGroup actionGroup = (ActionGroup)action;
                JMenu subMenu = new JMenu(SwingFrontend.adaptAction(action));
                SwingMenuBar.addActions(subMenu, actionGroup.getItems());
                menu.add(subMenu);
                continue;
            }
            if (action instanceof Separator) {
                menu.addSeparator();
                continue;
            }
            menu.add(new JMenuItem(SwingFrontend.adaptAction(action)));
        }
    }

    private void setInheritMenu(JComponent component) {
        component.setInheritsPopupMenu(true);
        for (Component c : component.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            this.setInheritMenu((JComponent)c);
        }
    }

    public boolean tryToClose() {
        return this.tryToCloseDialogs();
    }

    public class VerticalLayoutManager
    implements LayoutManager {
        private Dimension preferredSize = null;

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (this.preferredSize == null) {
                this.layoutContainer(parent);
            }
            return this.preferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(100, 100);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void layoutContainer(Container parent) {
            void var5_8;
            ArrayList<Component> visibleComponents = new ArrayList<Component>(Arrays.asList(parent.getComponents()));
            visibleComponents.removeIf(component -> !component.isVisible());
            int minSum = 0;
            for (Component component2 : visibleComponents) {
                minSum += component2.getMinimumSize().height;
            }
            HashSet<Component> verticallyGrowingComponents = new HashSet<Component>();
            for (Component component3 : visibleComponents) {
                if (component3.getPreferredSize().height <= component3.getMinimumSize().height) continue;
                verticallyGrowingComponents.add(component3);
            }
            if (parent.getComponentCount() > 0) {
                verticallyGrowingComponents.add(parent.getComponent(parent.getComponentCount() - 1));
            }
            boolean bl = false;
            int x = 0;
            int width = parent.getWidth();
            int widthWithoutIns = width - x;
            int moreThanMin = SwingTab.this.contentScrollPane.getHeight() - minSum;
            if (moreThanMin < 0) {
                verticallyGrowingComponents.clear();
            }
            for (Component component4 : visibleComponents) {
                int height = component4.getMinimumSize().height;
                if (verticallyGrowingComponents.contains(component4)) {
                    height += moreThanMin / verticallyGrowingComponents.size();
                }
                component4.setBounds(x, (int)var5_8, widthWithoutIns, height);
                var5_8 += height;
            }
            this.preferredSize = new Dimension(100, (int)var5_8);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.preferredSize = null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.preferredSize = null;
        }
    }

    private class SwingTabHistoryListener
    implements History.HistoryListener {
        private SwingTabHistoryListener() {
        }

        @Override
        public void onHistoryChanged() {
            SwingTab.this.visiblePageAndDetailsList.clear();
            SwingTab.this.verticalPanel.removeAll();
            for (Page page : (List)SwingTab.this.history.getPresent()) {
                SwingTab.this.addPageOrDetail(page);
            }
            SwingTab.this.onHistoryChanged();
        }
    }

    private class ScrollToNewPageAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        public ScrollToNewPageAction() {
            this.putValue("SwingSelectedKey", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public boolean isSelected() {
            return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
        }
    }

    private class NavigationAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;
        private int lastDividerLocation;

        public NavigationAction() {
            this.putValue("SwingSelectedKey", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Boolean.TRUE.equals(this.getValue("SwingSelectedKey"))) {
                SwingTab.this.splitPane.setLeftComponent(SwingTab.this.decoratedNavigationPane);
                SwingTab.this.splitPane.setDividerSize((Integer)UIManager.get("SplitPane.dividerSize"));
                SwingTab.this.splitPane.setDividerLocation(this.lastDividerLocation);
            } else {
                this.lastDividerLocation = SwingTab.this.splitPane.getDividerLocation();
                SwingTab.this.splitPane.setLeftComponent(null);
                SwingTab.this.splitPane.setDividerSize(0);
            }
        }
    }

    private class CloseTabAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        private CloseTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingTab.this.frame.closeTab();
        }
    }

    protected class RefreshAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        protected RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class NextPageAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        protected NextPageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingFrontend.runWithContext(() -> SwingTab.this.next());
        }
    }

    protected class PreviousPageAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        protected PreviousPageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingFrontend.runWithContext(() -> SwingTab.this.previous());
        }
    }
}

