/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.util.StringUtils;
import org.minimalj.util.resources.Resources;

public abstract class SwingResourceAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    protected SwingResourceAction() {
        String actionName = this.getClass().getSimpleName();
        SwingResourceAction.initProperties(this, actionName);
    }

    protected SwingResourceAction(String actionName) {
        SwingResourceAction.initProperties(this, actionName);
    }

    public static Action initProperties(Action action, String baseName) {
        Icon largeIcon;
        Icon smallIcon;
        Icon icon;
        KeyStroke key;
        Integer index;
        String text = Resources.getString(baseName);
        action.putValue("Name", text);
        action.putValue("MnemonicKey", SwingResourceAction.keyCode(text));
        Integer mnemonic = SwingResourceAction.getKeyCode(baseName + ".mnemonic");
        if (mnemonic != null) {
            action.putValue("MnemonicKey", mnemonic);
        }
        if ((index = Resources.getInteger(baseName + ".displayedMnemonicIndex", false)) != null) {
            action.putValue("SwingDisplayedMnemonicIndexKey", index);
        }
        if ((key = SwingResourceAction.getKeyStroke(baseName + ".accelerator")) != null) {
            action.putValue("AcceleratorKey", key);
        }
        if ((icon = SwingFrontend.getIcon(baseName + ".icon")) != null) {
            action.putValue("SmallIcon", icon);
            action.putValue("SwingLargeIconKey", icon);
        }
        if ((smallIcon = SwingFrontend.getIcon(baseName + ".smallIcon")) != null) {
            action.putValue("SmallIcon", smallIcon);
        }
        if ((largeIcon = SwingFrontend.getIcon(baseName + ".largeIcon")) != null) {
            action.putValue("SwingLargeIconKey", largeIcon);
        }
        SwingResourceAction.addValue(action, "ShortDescription", baseName + ".description");
        return action;
    }

    private static void addValue(Action action, String actionKey, String property) {
        if (Resources.isAvailable(property)) {
            action.putValue(actionKey, Resources.getString(property));
        }
    }

    public static KeyStroke getKeyStroke(String resourceName) {
        if (Resources.isAvailable(resourceName)) {
            String keyStrokeString = Resources.getString(resourceName);
            return KeyStroke.getKeyStroke(keyStrokeString);
        }
        return null;
    }

    public static Integer getKeyCode(String resourceName) {
        if (Resources.isAvailable(resourceName)) {
            String mnemonicString = Resources.getString(resourceName);
            return SwingResourceAction.keyCode(mnemonicString);
        }
        return null;
    }

    private static Integer keyCode(String mnemonicString) {
        if (!StringUtils.isEmpty(mnemonicString)) {
            int mnemonicKey = mnemonicString.charAt(0);
            if (mnemonicKey >= 97 && mnemonicKey <= 122) {
                mnemonicKey -= 32;
            }
            return mnemonicKey;
        }
        return null;
    }
}

