/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.DefaultEditorKit;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.action.ActionGroup;
import org.minimalj.frontend.action.Separator;
import org.minimalj.frontend.impl.swing.SwingResourceAction;
import org.minimalj.frontend.impl.swing.SwingTab;
import org.minimalj.frontend.impl.swing.lookAndFeel.LookAndFeelAction;
import org.minimalj.frontend.impl.swing.lookAndFeel.PrintLookAndFeel;
import org.minimalj.frontend.impl.swing.lookAndFeel.TerminalLargeFontLookAndFeel;
import org.minimalj.frontend.impl.swing.lookAndFeel.TerminalLookAndFeel;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.util.StringUtils;
import org.minimalj.util.resources.Resources;

public class SwingMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private final SwingTab tab;

    public SwingMenuBar(SwingTab tab) {
        this.tab = tab;
        this.add(this.createWindowMenu());
        this.add(this.createEditMenu());
        this.add(this.createViewMenu());
    }

    private JMenu createWindowMenu() {
        JMenu menu = this.menu("window");
        menu.add(new JMenuItem(this.tab.frame.newWindowAction));
        if (this.tab.frame.newWindowWithLoginAction != null) {
            menu.add(new JMenuItem(this.tab.frame.newWindowWithLoginAction));
        }
        menu.add(new JMenuItem(this.tab.frame.closeWindowAction));
        menu.addSeparator();
        menu.add(new JMenuItem(this.tab.frame.newTabAction));
        menu.add(new JMenuItem(this.tab.closeTabAction));
        if (this.tab.frame.loginAction != null) {
            menu.addSeparator();
            menu.add(new JMenuItem(this.tab.frame.loginAction));
        }
        menu.addSeparator();
        menu.add(new JMenuItem(this.tab.frame.exitAction));
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = this.menu("edit");
        menu.add(new JMenuItem(SwingResourceAction.initProperties(new DefaultEditorKit.CutAction(), "cut")));
        menu.add(new JMenuItem(SwingResourceAction.initProperties(new DefaultEditorKit.CopyAction(), "copy")));
        menu.add(new JMenuItem(SwingResourceAction.initProperties(new DefaultEditorKit.PasteAction(), "paste")));
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = this.menu("view");
        menu.add(new JMenuItem(this.tab.previousAction));
        menu.add(new JMenuItem(this.tab.nextAction));
        menu.add(new JMenuItem(this.tab.refreshAction));
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(this.tab.navigationAction));
        menu.addSeparator();
        menu.add(this.createPagesMenu());
        menu.addSeparator();
        menu.add(this.createLookAndFeeldMenu());
        return menu;
    }

    private JMenu createLookAndFeeldMenu() {
        JMenu menu = this.menu("lookAndFeel");
        menu.add(new JMenuItem(new LookAndFeelAction("system")));
        menu.add(new JMenuItem(new LookAndFeelAction("highContrast", TerminalLookAndFeel.class.getName())));
        menu.add(new JMenuItem(new LookAndFeelAction("highContrastLarge", TerminalLargeFontLookAndFeel.class.getName())));
        menu.add(new JMenuItem(new LookAndFeelAction("print", PrintLookAndFeel.class.getName())));
        return menu;
    }

    private JMenu createPagesMenu() {
        JMenu menu = this.menu("pages");
        ButtonGroup group = new ButtonGroup();
        group.add(new JRadioButtonMenuItem(new MaxVisiblePagesAction(1)));
        group.add(new JRadioButtonMenuItem(new MaxVisiblePagesAction(2)));
        group.add(new JRadioButtonMenuItem(new MaxVisiblePagesAction(0)));
        group.add(new JRadioButtonMenuItem(new MaxVisiblePagesAction(-1)));
        Collections.list(group.getElements()).forEach(abstractButton -> menu.add((Component)abstractButton));
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(Resources.getString("ScrollToNewPageAction")));
        return menu;
    }

    private JMenu menu(String resourceName) {
        String text = Resources.getString("Menu." + resourceName);
        JMenu menu = new JMenu(text);
        Integer mnemonic = SwingResourceAction.getKeyCode("Menu." + resourceName + ".mnemonic");
        if (mnemonic != null) {
            menu.setMnemonic(mnemonic);
        } else if (!StringUtils.isEmpty(text)) {
            menu.setMnemonic(text.charAt(0));
        }
        return menu;
    }

    public static void addActions(JMenu menu, List<Action> actions) {
        for (Action action : actions) {
            if (action instanceof ActionGroup) {
                ActionGroup actionGroup = (ActionGroup)action;
                JMenu subMenu = new JMenu(SwingFrontend.adaptAction(action));
                SwingMenuBar.addActions(subMenu, actionGroup.getItems());
                menu.add(subMenu);
                continue;
            }
            if (action instanceof Separator) {
                menu.addSeparator();
                continue;
            }
            menu.add(new JMenuItem(SwingFrontend.adaptAction(action)));
        }
    }

    private class MaxVisiblePagesAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;
        private final int maxPages;

        public MaxVisiblePagesAction(int maxPages) {
            super(MaxVisiblePagesAction.class.getSimpleName() + "." + maxPages);
            this.maxPages = maxPages;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingMenuBar.this.tab.setMaxPages(this.maxPages);
        }
    }
}

