/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.minimalj.application.Application;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.FrameManager;
import org.minimalj.frontend.impl.swing.SwingResourceAction;
import org.minimalj.frontend.impl.swing.SwingTab;
import org.minimalj.frontend.impl.swing.component.HideableTabbedPane;
import org.minimalj.frontend.page.Page;
import org.minimalj.security.Authentication;
import org.minimalj.security.Subject;
import org.minimalj.util.StringUtils;
import org.minimalj.util.resources.Resources;

public class SwingFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Subject subject;
    public static SwingFrame activeFrameOverride = null;
    private HideableTabbedPane tabbedPane;
    final Action loginAction;
    final Action closeWindowAction;
    final Action exitAction;
    final Action newWindowAction;
    final Action newWindowWithLoginAction;
    final Action newTabAction;

    public SwingFrame(Subject subject) {
        boolean authenticationActive = Backend.getInstance().isAuthenticationActive();
        this.loginAction = authenticationActive ? new SwingLoginAction() : null;
        this.closeWindowAction = new CloseWindowAction();
        this.exitAction = new ExitAction();
        this.newWindowAction = new NewWindowAction();
        this.newWindowWithLoginAction = authenticationActive ? new NewWindowWithLoginAction() : null;
        this.newTabAction = new NewTabAction();
        this.setDefaultSize();
        this.setLocationRelativeTo(null);
        this.addWindowListener();
        this.createContent();
        this.setSubject(subject);
        this.updateIcon();
        this.getRootPane().putClientProperty(SwingFrame.class.getSimpleName(), this);
    }

    protected void setDefaultSize() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (screenSize.width < 1280 || screenSize.height < 1024) {
            this.setExtendedState(6);
            this.setSize(screenSize.width - 20, screenSize.height - 40);
        } else {
            int width = Math.min(screenSize.width - 40, 1300);
            int height = Math.min(screenSize.height - 40, 1000);
            this.setSize(width, height);
        }
    }

    private void addWindowListener() {
        this.setDefaultCloseOperation(0);
        WindowAdapter listener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FrameManager.getInstance().closeWindowPerformed(SwingFrame.this);
            }
        };
        this.addWindowListener(listener);
    }

    protected void createContent() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createTabbedPane(), "Center");
    }

    private JComponent createTabbedPane() {
        this.tabbedPane = new HideableTabbedPane();
        this.addTab();
        return this.tabbedPane;
    }

    private void addTab() {
        SwingTab tab = new SwingTab(this);
        this.tabbedPane.addTab("", tab);
        this.tabbedPane.setSelectedComponent(tab);
        tab.show(Application.getInstance().createDefaultPage());
    }

    public void closeTabActionPerformed() {
        if (this.getVisibleTab().tryToClose()) {
            this.closeTab();
            if (this.tabbedPane.getTabCount() == 0) {
                if (FrameManager.getInstance().askBeforeCloseLastWindow(this)) {
                    FrameManager.getInstance().lastTabClosed(this);
                } else {
                    this.addTab();
                }
            }
        }
    }

    public boolean tryToCloseWindow() {
        boolean closable = true;
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            SwingTab tab = (SwingTab)this.tabbedPane.getTab(i);
            this.tabbedPane.setSelectedComponent(tab);
            closable = tab.tryToClose();
            if (closable) continue;
            return false;
        }
        this.closeWindow();
        return true;
    }

    public void closeTab(SwingTab tab) {
        this.tabbedPane.removeTab(tab);
    }

    private void closeAllTabs() {
        this.tabbedPane.removeAllTabs();
    }

    public void closeWindow() {
        this.closeAllTabs();
        this.setVisible(false);
    }

    public static SwingFrame getActiveWindow() {
        if (activeFrameOverride != null) {
            return activeFrameOverride;
        }
        for (Window w : Window.getWindows()) {
            if (!w.isActive()) continue;
            return (SwingFrame)w;
        }
        return null;
    }

    public SwingTab getVisibleTab() {
        SwingTab tab = (SwingTab)this.tabbedPane.getSelectedComponent();
        return tab;
    }

    public void closeTab() {
        this.closeTab((SwingTab)this.tabbedPane.getSelectedComponent());
    }

    public Page getVisiblePage() {
        SwingTab tab = this.getVisibleTab();
        if (tab == null) {
            return null;
        }
        return tab.getVisiblePage();
    }

    public List<Page> getPages() {
        ArrayList<Page> result = new ArrayList<Page>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            SwingTab tab = (SwingTab)this.tabbedPane.getComponent(i);
            Page page = tab.getVisiblePage();
            if (page == null) continue;
            result.add(page);
        }
        return result;
    }

    void onHistoryChanged() {
        this.updateTitle();
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
        Subject.setCurrent(subject);
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ((SwingTab)this.tabbedPane.getTab(i)).updateNavigation();
        }
        this.updateWindowTitle();
    }

    public Subject getSubject() {
        return this.subject;
    }

    protected void updateWindowTitle() {
        String title = Application.getInstance().getName();
        if (this.subject != null && !StringUtils.isEmpty(this.subject.getName())) {
            title = title + " - " + this.subject.getName();
        }
        this.setTitle(title);
    }

    protected void updateTitle() {
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            SwingTab tab = (SwingTab)this.tabbedPane.getTab(index);
            if (tab == null) {
                throw new RuntimeException("Tab null");
            }
            Page page = tab.getVisiblePage();
            if (page == null) {
                throw new RuntimeException("Page null");
            }
            this.tabbedPane.setTitleAt(index, page.getTitle());
        }
    }

    protected void updateIcon() {
        InputStream inputStream = Application.getInstance().getIcon();
        if (inputStream != null) {
            try {
                this.setIconImage(ImageIO.read(inputStream));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class NewTabAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        private NewTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingFrame.this.addTab();
        }
    }

    private class NewWindowWithLoginAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        private NewWindowWithLoginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameManager.getInstance().openNavigationFrame(null);
        }
    }

    private class NewWindowAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        private NewWindowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameManager.getInstance().openNavigationFrame(SwingFrame.this.subject);
        }
    }

    private class ExitAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        private ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameManager.getInstance().exitActionPerformed(SwingFrame.this);
        }
    }

    private class CloseWindowAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        private CloseWindowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingFrame.this.tryToCloseWindow();
        }
    }

    private class SwingLoginAction
    extends SwingResourceAction {
        private static final long serialVersionUID = 1L;

        public SwingLoginAction() {
            super("LoginAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingFrame.this.tabbedPane.getTabCount() > 1) {
                Frontend.showMessage(Resources.getString("Login.moreThanOneTab"));
                return;
            }
            Authentication.LoginListener listener = new Authentication.LoginListener(){

                @Override
                public void loginSucceded(Subject subject) {
                    SwingFrame.this.setSubject(subject);
                }

                @Override
                public void loginCancelled() {
                }
            };
            Backend.getInstance().getAuthentication().login(listener);
        }
    }
}

