/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.minimalj.application.Application;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.FrameManager;
import org.minimalj.frontend.impl.swing.SwingBackend;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.model.test.ModelTest;

public class Swing
implements Runnable {
    private Swing() {
    }

    @Override
    public void run() {
        FrameManager.setSystemLookAndFeel();
        Frontend.setInstance(new SwingFrontend());
        Backend.setInstance(new SwingBackend(Backend.create()));
        FrameManager.getInstance().openNavigationFrame(null);
    }

    private static void start() {
        ModelTest.exitIfProblems();
        try {
            SwingUtilities.invokeAndWait(new Swing());
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void start(Application application) {
        Application.setInstance(application);
        Swing.start();
    }

    public static void main(String ... args) {
        Application.initApplication(args);
        Swing.start();
    }
}

