/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.minimalj.application.DevMode;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.SwingFrame;
import org.minimalj.security.Authentication;
import org.minimalj.security.Subject;
import org.minimalj.util.resources.Resources;

public class FrameManager {
    private static Logger logger = Logger.getLogger(FrameManager.class.getName());
    private static FrameManager instance = new FrameManager();
    private List<SwingFrame> navigationFrames = new ArrayList<SwingFrame>();

    private FrameManager() {
    }

    public static void setSystemLookAndFeel() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", Resources.getString("Application.name"));
            String name = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(name);
        }
        catch (Exception e) {
            String s = "Couldn't set system LookandFeel";
            logger.log(Level.WARNING, s, e);
        }
    }

    public static FrameManager getInstance() {
        return instance;
    }

    public void openNavigationFrame(Subject subject) {
        final SwingFrame frame = new SwingFrame(subject);
        frame.setVisible(true);
        this.navigationFrames.add(frame);
        if (subject == null && Frontend.loginAtStart()) {
            SwingFrame.activeFrameOverride = frame;
            Authentication.LoginListener loginListener = new Authentication.LoginListener(){

                @Override
                public void loginSucceded(Subject subject) {
                    frame.setSubject(subject);
                }

                @Override
                public void loginCancelled() {
                    frame.closeWindow();
                    FrameManager.this.removeNavigationFrameView(frame);
                }
            };
            Backend.getInstance().getAuthentication().login(loginListener);
            SwingFrame.activeFrameOverride = null;
        }
    }

    public List<SwingFrame> getNavigationFrames() {
        return this.navigationFrames;
    }

    public void closeWindowPerformed(SwingFrame frameView) {
        if (!this.navigationFrames.contains(frameView)) {
            return;
        }
        if (this.navigationFrames.size() == 1 && !this.askBeforeExit(frameView)) {
            return;
        }
        if (frameView.tryToCloseWindow()) {
            this.removeNavigationFrameView(frameView);
        }
    }

    public void exitActionPerformed(SwingFrame navigationFrameView) {
        if (this.askBeforeExit(navigationFrameView)) {
            this.closeAllWindows(navigationFrameView);
        }
    }

    public void lastTabClosed(SwingFrame frameView) {
        frameView.closeWindow();
        this.removeNavigationFrameView(frameView);
    }

    public boolean askBeforeCloseLastWindow(SwingFrame navigationFrameView) {
        if (this.navigationFrames.size() == 1) {
            return this.askBeforeExit(navigationFrameView);
        }
        return true;
    }

    private boolean askBeforeExit(SwingFrame navigationFrameView) {
        if (DevMode.isActive()) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(navigationFrameView, Resources.getString("Exit.confirm"), Resources.getString("Exit.confirm.title"), 0);
        return answer == 0;
    }

    private boolean closeAllWindows(SwingFrame navigationFrameView) {
        for (int i = this.navigationFrames.size() - 1; i >= 0; --i) {
            SwingFrame frameView = this.navigationFrames.get(i);
            if (!frameView.tryToCloseWindow()) {
                return false;
            }
            this.removeNavigationFrameView(frameView);
        }
        return true;
    }

    private void removeNavigationFrameView(SwingFrame frameView) {
        this.navigationFrames.remove(frameView);
        if (this.navigationFrames.size() == 0) {
            System.exit(0);
        }
    }
}

