/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.nanoserver;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.application.Application;
import org.minimalj.application.Configuration;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonFrontend;
import org.minimalj.frontend.impl.nanoserver.MjWebDaemon;
import org.minimalj.frontend.impl.nanoserver.MjWebSocketDaemon;
import org.minimalj.model.test.ModelTest;
import org.minimalj.util.StringUtils;

public class NanoWebServer {
    private static final Logger LOG = Logger.getLogger(NanoWebServer.class.getName());
    private static final boolean SECURE = true;
    private static final int TIME_OUT = 300000;
    private static boolean useWebSocket = Boolean.valueOf(Configuration.get("MjUseWebSocket", "false"));

    private static void start(boolean secure) {
        int port = NanoWebServer.getPort(secure);
        if (port > 0) {
            LOG.info("Start " + Application.getInstance().getClass().getSimpleName() + " web " + (useWebSocket ? "socket " : "") + "frontend on port " + port + (secure ? " (Secure)" : ""));
            MjWebDaemon nanoHTTPD = useWebSocket ? NanoWebServer.newMjWebSocketDaemon(port, secure) : new MjWebDaemon(port, secure);
            try {
                nanoHTTPD.start(300000, false);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private static int getPort(boolean secure) {
        String portString = Configuration.get("MjFrontendPort" + (secure ? "Ssl" : ""), secure ? "-1" : "8080");
        return !StringUtils.isEmpty(portString) ? Integer.valueOf(portString) : -1;
    }

    private static NanoHTTPD newMjWebSocketDaemon(int port, boolean secure) {
        try {
            return new MjWebSocketDaemonFactory().create(port, secure);
        }
        catch (NoClassDefFoundError e) {
            LOG.log(Level.SEVERE, "Probably the dependency to nanohttpd-websocket is missing");
            throw e;
        }
    }

    public static void start(Application application) {
        Application.setInstance(application);
        Frontend.setInstance(new JsonFrontend());
        ModelTest.exitIfProblems();
        NanoWebServer.start(false);
        NanoWebServer.start(true);
    }

    public static void main(String ... args) {
        Application.initApplication(args);
        Frontend.setInstance(new JsonFrontend());
        ModelTest.exitIfProblems();
        NanoWebServer.start(false);
        NanoWebServer.start(true);
    }

    private static class MjWebSocketDaemonFactory {
        private MjWebSocketDaemonFactory() {
        }

        public NanoHTTPD create(int port, boolean secure) {
            return new MjWebSocketDaemon(port, secure);
        }
    }
}

