/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonInputComponent;

public class JsonTextField
extends JsonInputComponent<String>
implements Frontend.Input<String> {
    public static final String MAX_LENGTH = "maxLength";
    public static final String INPUT_TYPE = "inputType";
    private static final String ALLOWED_CHARACTERS = "allowedCharacters";
    private static final String SUGGESTIONS = "suggestions";
    private final Frontend.Search<String> suggestions;

    public JsonTextField(String type) {
        super(type, null);
        this.suggestions = null;
    }

    public JsonTextField(String type, Frontend.InputComponentListener changeListener) {
        super(type, changeListener);
        this.suggestions = null;
    }

    public JsonTextField(String type, int maxLength, String allowedCharacters, Frontend.InputType inputType, Frontend.Search<String> suggestions, Frontend.InputComponentListener changeListener) {
        super(type, changeListener);
        this.suggestions = suggestions;
        this.put(MAX_LENGTH, (Object)maxLength);
        if (inputType != null) {
            if (inputType == Frontend.InputType.DATETIME) {
                this.put(INPUT_TYPE, (Object)"datetime-local");
            } else {
                this.put(INPUT_TYPE, (Object)inputType.name().toLowerCase());
            }
        } else {
            this.put(ALLOWED_CHARACTERS, (Object)allowedCharacters);
        }
        if (suggestions != null) {
            this.put(SUGGESTIONS, (Object)"true");
        }
    }

    public Frontend.Search<String> getSuggestions() {
        return this.suggestions;
    }

    @Override
    public void setValue(String text) {
        this.put("value", (Object)text);
    }

    @Override
    public String getValue() {
        return (String)this.get("value");
    }
}

