/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonComponent;
import org.minimalj.model.Keys;
import org.minimalj.model.Rendering;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.Sortable;
import org.minimalj.util.resources.Resources;

public class JsonTable<T>
extends JsonComponent
implements Frontend.ITable<T> {
    private static final Logger logger = Logger.getLogger(JsonTable.class.getName());
    private static final int PAGE_SIZE = 50;
    private final Object[] keys;
    private final List<PropertyInterface> properties;
    private final Frontend.TableActionListener<T> listener;
    private List<T> objects;
    private int visibleRows = 50;
    private Integer sortColumn = null;

    public JsonTable(Object[] keys, boolean multiSelect, Frontend.TableActionListener<T> listener) {
        super("Table");
        this.keys = keys;
        this.properties = JsonTable.convert(keys);
        this.listener = listener;
        ArrayList<String> headers = new ArrayList<String>();
        for (PropertyInterface property : this.properties) {
            String header = Resources.getPropertyName(property);
            headers.add(header);
        }
        this.put("headers", (Object)headers);
        this.put("multiSelect", (Object)multiSelect);
        this.put("tableContent", (Object)Collections.emptyList());
    }

    private static List<PropertyInterface> convert(Object[] keys) {
        ArrayList<PropertyInterface> properties = new ArrayList<PropertyInterface>(keys.length);
        for (Object key : keys) {
            PropertyInterface property = Keys.getProperty(key);
            if (property != null) {
                properties.add(property);
                continue;
            }
            logger.log(Level.WARNING, "Key not a property: " + key);
        }
        if (properties.size() == 0) {
            logger.log(Level.SEVERE, "PropertyTable without valid keys");
        }
        return properties;
    }

    @Override
    public void setObjects(List<T> objects) {
        this.objects = objects;
        this.visibleRows = 0;
        List<List<String>> tableContent = this.extendContent();
        this.put("tableContent", (Object)tableContent);
        this.put("size", (Object)objects.size());
        this.put("extendable", (Object)this.isExtendable());
    }

    public List<List<String>> extendContent() {
        int newVisibleRows = Math.min(this.objects.size(), this.visibleRows + 50);
        List<T> newVisibleObjects = this.objects.subList(this.visibleRows, newVisibleRows);
        this.visibleRows = newVisibleRows;
        return this.createTableContent(newVisibleObjects);
    }

    public boolean isExtendable() {
        return this.visibleRows < this.objects.size();
    }

    private List<List<String>> createTableContent(List<T> objects) {
        ArrayList<List<String>> tableContent = new ArrayList<List<String>>();
        for (T object : objects) {
            ArrayList<String> rowContent = new ArrayList<String>();
            for (PropertyInterface property : this.properties) {
                Object value = property.getValue(object);
                String stringValue = Rendering.render(value, Rendering.RenderType.PLAIN_TEXT, property);
                rowContent.add(stringValue);
            }
            tableContent.add(rowContent);
        }
        return tableContent;
    }

    public void action(int row) {
        T object = this.objects.get(row);
        this.listener.action(object);
    }

    public void selection(List<Number> selectedRows) {
        ArrayList<T> selectedObjects = new ArrayList<T>(selectedRows.size());
        for (Number r : selectedRows) {
            selectedObjects.add(this.objects.get(r.intValue()));
        }
        this.listener.selectionChanged(selectedObjects);
    }

    public void sort(int column) {
        Sortable sortable;
        if (this.objects instanceof Sortable && (sortable = (Sortable)((Object)this.objects)).canSortBy(this.keys[column])) {
            this.sortColumn = this.sortColumn == null ? Integer.valueOf(column) : (this.sortColumn == column ? Integer.valueOf(-this.sortColumn.intValue()) : Integer.valueOf(++column));
            if (this.objects instanceof Sortable) {
                Object[] keys = new Object[]{this.keys[Math.abs(this.sortColumn) - 1]};
                sortable.sort(keys, new boolean[]{this.sortColumn > 0});
            }
            this.setObjects(this.objects);
        }
    }
}

