/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.minimalj.frontend.impl.json.JsonWriter;

public class JsonOutput {
    private static final String PROPERTY_CHANGES = "propertyChanges";
    private static final String CONTENT_CHANGES = "contentChanges";
    private final JsonWriter writer = new JsonWriter();
    private final Map<String, Object> output = new LinkedHashMap<String, Object>();

    public void propertyChange(String componentId, String property, Object value) {
        Map propertyChangesByElement;
        if (!this.output.containsKey(PROPERTY_CHANGES)) {
            this.output.put(PROPERTY_CHANGES, new HashMap());
        }
        if (!(propertyChangesByElement = (Map)this.output.get(PROPERTY_CHANGES)).containsKey(componentId)) {
            propertyChangesByElement.put(componentId, new HashMap());
        }
        Map valuesByProperty = (Map)propertyChangesByElement.get(componentId);
        valuesByProperty.put(property, value);
    }

    public void removeContent(String componentId) {
        this.addContent(componentId, "clear");
    }

    public void addContent(String componentId, Object value) {
        List<Object> contentByProperty = this.getContentById(componentId);
        contentByProperty.add(value);
    }

    private List<Object> getContentById(String componentId) {
        Map contentChangesByElement;
        if (!this.output.containsKey(CONTENT_CHANGES)) {
            this.output.put(CONTENT_CHANGES, new HashMap());
        }
        if (!(contentChangesByElement = (Map)this.output.get(CONTENT_CHANGES)).containsKey(componentId)) {
            contentChangesByElement.put(componentId, new ArrayList());
        }
        List contentByProperty = (List)contentChangesByElement.get(componentId);
        return contentByProperty;
    }

    public void add(String name, Object object) {
        this.output.put(name, object);
    }

    public String toString() {
        return this.writer.write(this.output);
    }
}

