/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonDialog;
import org.minimalj.frontend.impl.json.JsonInputComponent;
import org.minimalj.model.Rendering;
import org.minimalj.util.EqualsHelper;

public class JsonLookup<T>
extends JsonInputComponent<T>
implements Frontend.Input<T> {
    private final Object[] keys;
    private final Frontend.Search<T> search;
    private T selectedObject;
    private JsonDialog dialog;

    public JsonLookup(Frontend.InputComponentListener listener, Frontend.Search<T> search, Object[] keys) {
        super("Lookup", listener);
        this.search = search;
        this.keys = keys;
    }

    public JsonDialog showLookupDialog() {
        this.dialog = new JsonDialog.JsonSearchDialog<T>(this.search, this.keys, new JsonLookupTableListener());
        return this.dialog;
    }

    @Override
    public void setValue(T object) {
        if (!EqualsHelper.equals(this.selectedObject, object)) {
            this.selectedObject = object;
            this.put("value", (Object)this.render(this.selectedObject));
            this.fireChange();
        }
    }

    protected String render(T object) {
        if (object instanceof Rendering) {
            Rendering rendering = (Rendering)object;
            return rendering.render(Rendering.RenderType.PLAIN_TEXT);
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    @Override
    public T getValue() {
        return this.selectedObject;
    }

    private class JsonLookupTableListener
    implements Frontend.TableActionListener<T> {
        private JsonLookupTableListener() {
        }

        @Override
        public void action(T selectedObject) {
            JsonLookup.this.setValue(selectedObject);
            JsonLookup.this.dialog.closeDialog();
        }
    }
}

