/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.minimalj.application.Application;
import org.minimalj.application.Configuration;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.json.JsonAction;
import org.minimalj.frontend.impl.json.JsonCheckBox;
import org.minimalj.frontend.impl.json.JsonCombobox;
import org.minimalj.frontend.impl.json.JsonComponent;
import org.minimalj.frontend.impl.json.JsonFormContent;
import org.minimalj.frontend.impl.json.JsonHtmlContent;
import org.minimalj.frontend.impl.json.JsonList;
import org.minimalj.frontend.impl.json.JsonLookup;
import org.minimalj.frontend.impl.json.JsonPageManager;
import org.minimalj.frontend.impl.json.JsonPasswordField;
import org.minimalj.frontend.impl.json.JsonSwitchContent;
import org.minimalj.frontend.impl.json.JsonTable;
import org.minimalj.frontend.impl.json.JsonText;
import org.minimalj.frontend.impl.json.JsonTextField;
import org.minimalj.frontend.page.PageManager;
import org.minimalj.model.Rendering;
import org.minimalj.util.LocaleContext;
import org.minimalj.util.resources.Resources;

public class JsonFrontend
extends Frontend {
    private static boolean useWebSocket = Boolean.valueOf(Configuration.get("MjUseWebSocket", "false"));
    private static ThreadLocal<JsonPageManager> sessionByThread = new ThreadLocal();
    private static ThreadLocal<Boolean> useInputTypesByThread = new ThreadLocal();

    public static void setSession(JsonPageManager session) {
        sessionByThread.set(session);
    }

    public static JsonPageManager getClientSession() {
        return sessionByThread.get();
    }

    public static void setUseInputTypes(boolean compact) {
        useInputTypesByThread.set(compact);
    }

    @Override
    public PageManager getPageManager() {
        return JsonFrontend.getClientSession();
    }

    @Override
    public Frontend.IComponent createText(String string) {
        return new JsonText((Object)string);
    }

    @Override
    public Frontend.IComponent createText(Action action) {
        return new JsonAction(action);
    }

    @Override
    public Frontend.IComponent createText(Rendering rendering) {
        return new JsonText(rendering);
    }

    @Override
    public Frontend.IComponent createTitle(String string) {
        JsonComponent component = new JsonComponent("Title");
        component.put("value", (Object)string);
        return component;
    }

    @Override
    public Frontend.Input<String> createReadOnlyTextField() {
        return new JsonTextField("ReadOnlyTextField");
    }

    @Override
    public Frontend.Input<String> createTextField(int maxLength, String allowedCharacters, Frontend.Search<String> suggestionSearch, Frontend.InputComponentListener changeListener) {
        return new JsonTextField("TextField", maxLength, allowedCharacters, null, suggestionSearch, changeListener);
    }

    @Override
    public Optional<Frontend.Input<String>> createInput(int maxLength, Frontend.InputType inputType, Frontend.InputComponentListener changeListener) {
        if (useInputTypesByThread.get().booleanValue()) {
            return Optional.of(new JsonTextField("TextField", maxLength, null, inputType, null, changeListener));
        }
        return Optional.empty();
    }

    @Override
    public Frontend.PasswordField createPasswordField(Frontend.InputComponentListener changeListener, int maxLength) {
        return new JsonPasswordField(maxLength, changeListener);
    }

    @Override
    public Frontend.Input<String> createAreaField(int maxLength, String allowedCharacters, Frontend.InputComponentListener changeListener) {
        return new JsonTextField("AreaField", maxLength, allowedCharacters, null, null, changeListener);
    }

    @Override
    public Frontend.Input<byte[]> createImage(int size, Frontend.InputComponentListener changeListener) {
        throw new RuntimeException("Image not yet implemented in JsonFrontend");
    }

    @Override
    public Frontend.IList createList(Action ... actions) {
        return new JsonList(actions);
    }

    @Override
    public <T> Frontend.Input<T> createComboBox(List<T> objects, Frontend.InputComponentListener changeListener) {
        return new JsonCombobox<T>(objects, changeListener);
    }

    @Override
    public Frontend.Input<Boolean> createCheckBox(Frontend.InputComponentListener changeListener, String text) {
        return new JsonCheckBox(text, changeListener);
    }

    @Override
    public <T> Frontend.ITable<T> createTable(Object[] keys, boolean multiSelect, Frontend.TableActionListener<T> listener) {
        return new JsonTable<T>(keys, multiSelect, listener);
    }

    @Override
    public <T> Frontend.Input<T> createLookup(Frontend.InputComponentListener changeListener, Frontend.Search<T> index, Object[] keys) {
        return new JsonLookup<T>(changeListener, index, keys);
    }

    @Override
    public Frontend.IComponent createComponentGroup(Frontend.IComponent ... components) {
        JsonComponent group = new JsonComponent("Group");
        if (components.length > 0) {
            group.put("firstId", ((JsonComponent)components[0]).get("id"));
        }
        group.put("components", (Object)Arrays.asList(components));
        return group;
    }

    @Override
    public Frontend.FormContent createFormContent(int columns, int columnWidth) {
        return new JsonFormContent(columns, columnWidth);
    }

    @Override
    public Frontend.SwitchContent createSwitchContent() {
        return new JsonSwitchContent();
    }

    @Override
    public Frontend.IContent createHtmlContent(String htmlOrUrl) {
        return new JsonHtmlContent(htmlOrUrl);
    }

    public static boolean useWebSocket() {
        return useWebSocket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStream(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String string = reader.lines().collect(Collectors.joining(System.getProperty("line.separator")));
            return string;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static String getHtmlTemplate() {
        return JsonFrontend.readStream(JsonFrontend.class.getResourceAsStream("/index.html"));
    }

    public static String fillPlaceHolder(String html, Locale locale) {
        LocaleContext.setCurrent(locale);
        String result = html.replace("$LOCALE", locale.getLanguage());
        result = result.replace("$LOGIN", Boolean.toString(Backend.getInstance().isAuthenticationActive()));
        result = result.replace("$WEB_SOCKET", Boolean.toString(JsonFrontend.useWebSocket()));
        result = result.replace("$PORT", "");
        result = result.replace("$WS", "ws");
        result = result.replace("$DISABLED_SEARCH", Application.getInstance().hasSearchPages() ? "" : "disabled");
        result = result.replace("$SEARCH", Resources.getString("SearchAction"));
        result = result.replace("$MINIMALJ-VERSION", "Minimal-J Version: " + Application.class.getPackage().getImplementationVersion());
        result = result.replace("$APPLICATION-VERSION", "Application Version: " + Application.getInstance().getClass().getPackage().getImplementationVersion());
        result = result.replace("$ICON", JsonFrontend.getIconLink());
        return result;
    }

    private static String getIconLink() {
        if (Application.getInstance().getIcon() != null) {
            return "<link rel=\"icon\" href=\"application.png\" type=\"image/png\">";
        }
        return "";
    }
}

