/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonInputComponent;
import org.minimalj.model.Rendering;

public class JsonCombobox<T>
extends JsonInputComponent<T> {
    private final Map<String, T> objectById = new LinkedHashMap<String, T>();
    private final Map<String, Object> options = new LinkedHashMap<String, Object>();

    public JsonCombobox(List<T> objects, Frontend.InputComponentListener changeListener) {
        super("Combobox", changeListener);
        for (T object : objects) {
            String text;
            String id = UUID.randomUUID().toString();
            if (object instanceof Rendering) {
                Rendering rendering = (Rendering)object;
                text = rendering.render(Rendering.RenderType.PLAIN_TEXT);
            } else {
                text = "" + object;
            }
            this.options.put(id, text);
            this.objectById.put(id, object);
        }
        this.put("options", (Object)this.options);
    }

    @Override
    public void setValue(T object) {
        for (Map.Entry<String, T> entry : this.objectById.entrySet()) {
            if (!Objects.equals(entry.getValue(), object)) continue;
            this.put("value", (Object)entry.getKey());
            return;
        }
        this.put("value", (Object)null);
    }

    @Override
    public T getValue() {
        String selectedId = (String)this.get("value");
        if (selectedId != null) {
            return this.objectById.get(selectedId);
        }
        return null;
    }
}

