/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.AbstractFormElement;
import org.minimalj.frontend.form.element.Enable;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.AnnotationUtil;
import org.minimalj.model.properties.PropertyInterface;

public class StringFormElement
extends AbstractFormElement<String>
implements Enable {
    public static final Boolean MULTI_LINE = Boolean.TRUE;
    public static final Boolean SINGLE_LINE = Boolean.FALSE;
    public static final Boolean AUTOMATIC = false;
    private final int maxLength;
    private final Frontend.Input<String> textField;

    public StringFormElement(Object key, Boolean multiLine) {
        this(Keys.getProperty(key), multiLine);
    }

    public StringFormElement(PropertyInterface property) {
        this(property, null);
    }

    public StringFormElement(PropertyInterface property, Boolean multiLine) {
        super(property);
        this.maxLength = AnnotationUtil.getSize(property);
        this.textField = this.maxLength < 256 && !Boolean.TRUE.equals(multiLine) || Boolean.FALSE.equals(multiLine) ? Frontend.getInstance().createTextField(this.maxLength, null, null, this.listener()) : Frontend.getInstance().createAreaField(this.maxLength, null, this.listener());
    }

    @Override
    public Frontend.IComponent getComponent() {
        return this.textField;
    }

    @Override
    public void setValue(String string) {
        if (string != null && this.maxLength > 0 && string.length() > this.maxLength) {
            string = string.substring(0, this.maxLength);
        }
        this.textField.setValue(string);
    }

    @Override
    public String getValue() {
        return this.textField.getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEditable(enabled);
    }
}

