/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.FormatFormElement;
import org.minimalj.model.annotation.AnnotationUtil;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;

public abstract class NumberFormElement<T>
extends FormatFormElement<T> {
    protected final boolean signed;
    protected final int size;
    protected final int decimalPlaces;

    protected NumberFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
        this.size = AnnotationUtil.getSize(property);
        this.decimalPlaces = AnnotationUtil.getDecimal(property);
        this.signed = AnnotationUtil.isSigned(property);
    }

    @Override
    protected Frontend.InputType getInputType() {
        return Frontend.InputType.NUMBER;
    }

    @Override
    public String render(T number) {
        String string = null;
        if (number != null) {
            string = InvalidValues.isInvalid(number) ? InvalidValues.getInvalidValue(number) : number.toString();
        }
        return string;
    }

    @Override
    protected String getAllowedCharacters(PropertyInterface property) {
        if (this.decimalPlaces > 0) {
            return this.signed ? "-0123456789." : "0123456789.";
        }
        return this.signed ? "-0123456789" : "0123456789";
    }

    @Override
    protected int getAllowedSize(PropertyInterface property) {
        return this.size + (this.signed ? 1 : 0) + (this.decimalPlaces > 0 ? 1 : 0);
    }
}

