/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.List;
import java.util.Optional;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.AbstractFormElement;
import org.minimalj.frontend.form.element.Enable;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.model.validation.Validation;
import org.minimalj.model.validation.ValidationMessage;
import org.minimalj.util.StringUtils;
import org.minimalj.util.mock.Mocking;

public abstract class FormatFormElement<T>
extends AbstractFormElement<T>
implements Enable,
Mocking {
    private final boolean editable;
    protected Frontend.Input<String> textField;
    protected boolean typed;

    public FormatFormElement(PropertyInterface property, boolean editable) {
        super(property);
        this.editable = editable;
    }

    protected abstract String getAllowedCharacters(PropertyInterface var1);

    protected abstract int getAllowedSize(PropertyInterface var1);

    protected Frontend.InputType getInputType() {
        return Frontend.InputType.TEXT;
    }

    @Override
    public Frontend.IComponent getComponent() {
        if (this.textField == null) {
            if (this.editable) {
                Optional<Frontend.Input<String>> typeTextField = Frontend.getInstance().createInput(this.getAllowedSize(this.getProperty()), this.getInputType(), new TextFormatFieldChangeListener());
                this.typed = typeTextField.isPresent();
                this.textField = this.typed ? typeTextField.get() : Frontend.getInstance().createTextField(this.getAllowedSize(this.getProperty()), this.getAllowedCharacters(this.getProperty()), null, new TextFormatFieldChangeListener());
            } else {
                this.textField = Frontend.getInstance().createReadOnlyTextField();
            }
        }
        return this.textField;
    }

    @Override
    public final T getValue() {
        return this.parse(this.textField.getValue());
    }

    protected abstract T parse(String var1);

    @Override
    public final void setValue(T value) {
        String newString = this.render(value);
        if (!StringUtils.equals(newString, this.textField.getValue())) {
            this.textField.setValue(newString);
        }
    }

    protected abstract String render(T var1);

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEditable(enabled);
    }

    private class TextFormatFieldChangeListener
    implements Frontend.InputComponentListener {
        private TextFormatFieldChangeListener() {
        }

        @Override
        public void changed(Frontend.IComponent source) {
            Object value = FormatFormElement.this.getValue();
            boolean valid = true;
            valid &= !InvalidValues.isInvalid(value);
            if (value instanceof Validation) {
                List<ValidationMessage> validationMessages = ((Validation)value).validateNullSafe();
                valid &= validationMessages.isEmpty();
            }
            if (valid) {
                FormatFormElement.this.setValue(value);
            }
            FormatFormElement.this.fireChange();
        }
    }
}

